/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.string;

import java.nio.charset.Charset;

public class EncodingExplainer {
    private static final String[] TEST_CASES = new String[]{"\u00e9\u00e0\u00f9\u00ef\u00f4", "\u4e2d\u56fd", "\u00ba\u00dc\u00ba\u00c3\u00ba\u00dc\u00c7\u00bf\u00b4\u00f3"};
    private static final String[] CHARSETS = new String[]{"iso8859-1", "gb2312", "utf-8"};
    private static final String TOP_LEFT_LABEL = "Encode\\Decode";
    private static final int MAX_LENGTH = 14;

    private static void printEncodingTableFor(String text) {
        System.out.println("----------Test for <" + text + ">-----------");
        for (int i = 0; i < CHARSETS.length + 1; ++i) {
            for (int j = 0; j < CHARSETS.length + 1; ++j) {
                if (i == 0) {
                    if (j == 0) {
                        System.out.print(EncodingExplainer.appendWhitespaces(TOP_LEFT_LABEL));
                    } else {
                        System.out.print(EncodingExplainer.appendWhitespaces(CHARSETS[j - 1]));
                    }
                } else if (j == 0) {
                    System.out.print(EncodingExplainer.appendWhitespaces(CHARSETS[i - 1]));
                } else {
                    System.out.print(EncodingExplainer.appendWhitespaces(EncodingExplainer.decodeWith(EncodingExplainer.encodeWith(text, CHARSETS[i - 1]), CHARSETS[j - 1])));
                }
                if (j != CHARSETS.length) continue;
                System.out.println();
            }
        }
        System.out.println();
    }

    private static byte[] encodeWith(String text, String charsetName) {
        return text.getBytes(Charset.forName(charsetName));
    }

    private static String decodeWith(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    private static String appendWhitespaces(String text) {
        int num = 14 - text.length();
        for (int i = 0; i < num; ++i) {
            text = text + " ";
        }
        text = text + "\t";
        return text;
    }

    public static void main(String[] args) {
        for (String text : TEST_CASES) {
            EncodingExplainer.printEncodingTableFor(text);
        }
    }
}

