/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client;

import java.io.IOException;
import org.talend.commandline.client.CommandLineAbstractClient;
import org.talend.commandline.client.CommandLineJavaCLientException;
import org.talend.commandline.client.CommandLineJavaServerException;
import org.talend.commandline.client.command.CommandStatus;
import org.talend.commandline.client.command.IJavaCommand;
import org.talend.commandline.client.command.extension.ListCommandCommand;
import org.talend.commandline.client.command.extension.ListProjectsCommand;
import org.talend.commandline.client.filter.ItemFilter;
import org.talend.commandline.client.model.CommandLineCommandBean;
import org.talend.commandline.client.model.EProtocolResponse;
import org.talend.commandline.client.util.Base64SerializationHelper;
import org.talend.commandline.client.util.CommandStringBuilder;
import org.talend.commandline.client.util.FileTransferHandler;
import org.talend.commandline.client.util.ResponseInterpreter;

public class CommandLineJavaClient
extends CommandLineAbstractClient {
    private boolean passed;
    private IOException ioException;
    private CommandLineJavaCLientException cmdClientException;
    private CommandLineJavaServerException cmdServerException;
    private static int timeout = 30;

    public CommandLineJavaClient(String hostname, int port) {
        super(hostname, port);
    }

    public CommandLineJavaClient(String hostname) {
        super(hostname);
    }

    public CommandLineJavaClient(int port) {
        super(port);
    }

    public CommandLineJavaClient() {
    }

    @Override
    public void connect() throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        this.connect(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int timeout) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        this.passed = false;
        this.ioException = null;
        this.cmdClientException = null;
        this.cmdServerException = null;
        if (timeout <= 0) {
            super.connect();
            this.addCommand("javaProtocol");
            return;
        }
        new Thread(){

            @Override
            public void run() {
                CommandLineJavaClient.this.command();
            }
        }.start();
        try {
            CommandLineJavaClient commandLineJavaClient = this;
            synchronized (commandLineJavaClient) {
                this.wait(timeout * 1000);
            }
        }
        catch (InterruptedException e) {
            throw new CommandLineJavaCLientException(e);
        }
        if (this.passed) {
            return;
        }
        this.handleException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void command() {
        try {
            super.connect();
            this.addCommand("javaProtocol");
            CommandLineJavaClient commandLineJavaClient = this;
            synchronized (commandLineJavaClient) {
                this.passed = true;
                this.notify();
            }
        }
        catch (IOException e) {
            this.ioException = e;
        }
        catch (CommandLineJavaCLientException e) {
            this.cmdClientException = e;
        }
        catch (CommandLineJavaServerException e) {
            this.cmdServerException = e;
        }
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        block9: {
            long start = System.currentTimeMillis();
            try {
                try {
                    new CommandLineJavaClient("localhost", 8002).connect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf((System.currentTimeMillis() - start) / 1000L) + " sec");
                }
                catch (CommandLineJavaCLientException e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf((System.currentTimeMillis() - start) / 1000L) + " sec");
                }
                catch (CommandLineJavaServerException e) {
                    e.printStackTrace();
                    System.out.println(String.valueOf((System.currentTimeMillis() - start) / 1000L) + " sec");
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                System.out.println(String.valueOf((System.currentTimeMillis() - start) / 1000L) + " sec");
            }
        }
    }

    private void handleException() throws CommandLineJavaCLientException, IOException, CommandLineJavaServerException {
        if (this.ioException == null && this.cmdClientException == null && this.cmdServerException == null) {
            throw new CommandLineJavaCLientException("Timeout connected while trying to connect command line");
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.cmdClientException != null) {
            throw this.cmdClientException;
        }
        if (this.cmdServerException != null) {
            throw this.cmdServerException;
        }
    }

    public int addCommand(IJavaCommand command) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        return this.addCommand(command.writeToString());
    }

    private int addCommand(String commandString) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        return this.sendCommandAndParse(commandString, new ResponseInterpreter()).getAddedCommandId();
    }

    public String getResult(String commandString) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        return this.sendCommandAndParse(commandString, new ResponseInterpreter()).getResultString();
    }

    private ResponseInterpreter sendCommandAndParse(String commandString, ResponseInterpreter responseInterpreter) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        this.sendCommand(commandString);
        responseInterpreter.parse(this.inputStream);
        if (responseInterpreter.getException() != null) {
            throw responseInterpreter.getException();
        }
        return responseInterpreter;
    }

    public CommandStatus getStatus(int commandId) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        String command = "getCommandStatus " + commandId;
        return this.sendCommandAndParse(command, new ResponseInterpreter()).getCommandStatus();
    }

    public CommandStatus addCommandAndWait(IJavaCommand command) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException, InterruptedException {
        int commandId = this.addCommand(command.writeToString());
        return this.getCommandStatusAndWait(commandId);
    }

    public CommandStatus getCommandStatusAndWait(int commandId) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException, InterruptedException {
        CommandStatus status = this.getStatus(commandId);
        long sequence = 0L;
        while (status.getLevel() != CommandStatus.CommandStatusLevel.COMPLETED && status.getLevel() != CommandStatus.CommandStatusLevel.FAILED) {
            sequence = sequence == Long.MAX_VALUE ? Long.MAX_VALUE : ++sequence;
            Thread.sleep(this.calcSleepTime(sequence));
            status = this.getStatus(commandId);
        }
        return status;
    }

    private long calcSleepTime(long sequence) {
        long times = sequence / 10L;
        long sleepTime = 100L;
        if (times > 0L) {
            if ((sleepTime *= times) < 0L) {
                sleepTime = Long.MAX_VALUE;
            } else if (sleepTime < 100L) {
                sleepTime = 100L;
            }
        }
        return sleepTime;
    }

    public String getServerVersion() throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        String command = "showVersion";
        return this.sendCommandAndParse(command, new ResponseInterpreter()).getResultString();
    }

    public void getServerFile(String remotePath, String localPath) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        CommandStringBuilder builder = new CommandStringBuilder("getFile");
        builder.addArgument(remotePath);
        builder.addArgument(localPath);
        ResponseInterpreter responseInterpreter = new ResponseInterpreter();
        responseInterpreter.setFilePath(localPath);
        this.sendCommandAndParse(builder.toString(), responseInterpreter);
    }

    public void putServerFile(String localPath, String remotePath) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        CommandStringBuilder builder = new CommandStringBuilder("putFile");
        builder.addArgument(localPath);
        builder.addArgument(remotePath);
        ResponseInterpreter responseInterpreter = new ResponseInterpreter();
        responseInterpreter.setFilePath(localPath);
        this.sendCommandAndParse(builder.toString(), responseInterpreter);
        if (!responseInterpreter.getResultString().equals("OK")) {
            throw new CommandLineJavaCLientException("Client Server communication error");
        }
        this.printWriter.println(EProtocolResponse.BEGIN.getName());
        this.printWriter.print(String.valueOf(EProtocolResponse.FILE_SIZE.getName()) + " ");
        this.printWriter.println(FileTransferHandler.getFileSize(localPath));
        this.printWriter.println(EProtocolResponse.FILE_CONTENT.getName());
        this.printWriter.flush();
        FileTransferHandler.sendFile(localPath, this.outputStream);
        this.printWriter.print(String.valueOf(EProtocolResponse.FILE_MD5.getName()) + " ");
        this.printWriter.println(FileTransferHandler.getMD5(localPath));
        responseInterpreter = new ResponseInterpreter();
        responseInterpreter.setFilePath(localPath);
        this.sendCommandAndParse(EProtocolResponse.END.getName(), responseInterpreter);
        if (!responseInterpreter.getResultString().equals("OK")) {
            throw new CommandLineJavaCLientException("Client Server communication error");
        }
    }

    public String listProjects(boolean showBranch) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        ListProjectsCommand command = new ListProjectsCommand(showBranch);
        String resultString = this.sendCommandAndParse(command.writeToString(), new ResponseInterpreter()).getResultString();
        try {
            return (String)new Base64SerializationHelper().decode(resultString, String.class);
        }
        catch (Exception e) {
            throw new CommandLineJavaCLientException(e);
        }
    }

    public String listItems(ItemFilter itemFilter, boolean withMetadata) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        CommandStringBuilder builder = new CommandStringBuilder("listItem");
        if (itemFilter != null) {
            builder.addOptionWithArgument("if", itemFilter.writeToString());
        }
        if (withMetadata) {
            builder.addOption("m");
        }
        String resultString = this.sendCommandAndParse(builder.toString(), new ResponseInterpreter()).getResultString();
        try {
            return (String)new Base64SerializationHelper().decode(resultString, new Class[0]);
        }
        catch (Exception e) {
            throw new CommandLineJavaCLientException(e);
        }
    }

    public CommandLineCommandBean[] listCommands(boolean listAllCommand, boolean listQueueCommand, boolean listRunningCommand) throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        ListCommandCommand listComamnd = new ListCommandCommand(listAllCommand, listQueueCommand, listRunningCommand);
        return this.sendCommandAndParse(listComamnd.writeToString(), new ResponseInterpreter()).getCommandlineCommandBeans();
    }

    public String listJob() throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        String command = "listJob";
        String resultString = this.sendCommandAndParse(command, new ResponseInterpreter()).getResultString();
        try {
            return (String)new Base64SerializationHelper().decode(resultString, new Class[0]);
        }
        catch (Exception e) {
            throw new CommandLineJavaCLientException(e);
        }
    }
}

