/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command;

import org.talend.commandline.client.command.AbstractPublishCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class PublishServiceCommand
extends AbstractPublishCommand {
    public PublishServiceCommand(String itemName, String repositoryUrl, String userName, String password, String itemVersion, String artifactId, String publishVersion, String groupName, boolean isSnapshot) {
        super(itemName, repositoryUrl, userName, password, itemVersion, artifactId, publishVersion, groupName, isSnapshot);
    }

    public PublishServiceCommand(String itemName, String repositoryUrl, String repositoryType, String userName, String password, String itemVersion, String artifactId, String publishVersion, String groupName, boolean isSnapshot) {
        super(itemName, repositoryUrl, repositoryType, userName, password, itemVersion, artifactId, publishVersion, groupName, isSnapshot);
    }

    @Override
    public String writeToString() {
        return this.writeToString(false);
    }

    @Override
    public String writeToString(boolean forDisplay) {
        CommandStringBuilder builder = new CommandStringBuilder("publishService");
        builder.addArgument(this.itemName);
        builder.addOptionWithArgument("r", this.repositoryUrl);
        builder.addOptionWithArgument("rt", this.repositoryType);
        builder.addOptionWithArgument("v", this.itemVersion);
        builder.addOptionWithArgument("a", this.artifactId);
        builder.addOptionWithArgument("pv", this.publishVersion);
        if (this.userName != null) {
            builder.addOptionWithArgument("u", this.userName);
            if (this.password != null && this.password.length() > 0) {
                builder.addOptionWithArgument("p", this.getDisplayPassword(this.password, forDisplay));
            }
        }
        builder.addOptionWithArgument("g", this.groupName);
        if (this.isSnapshot) {
            builder.addOption("s");
        }
        return builder.toString();
    }
}

