/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class BuildItemSourcesCommand
extends AbstractServerCommand {
    private String itemId;
    private String version;
    private String mainJobOnly;

    public BuildItemSourcesCommand() {
    }

    public BuildItemSourcesCommand(String itemId, String version) {
        this.itemId = itemId;
        this.version = version;
    }

    public BuildItemSourcesCommand(String itemId, String version, String mainJobOnly) {
        this(itemId, version);
        this.mainJobOnly = mainJobOnly;
    }

    @Override
    public String writeToString() {
        String mbo;
        String itemVersion;
        CommandStringBuilder builder = new CommandStringBuilder("buildItemSources");
        if (this.getItemId() != null) {
            builder.addArgument(this.getItemId());
        }
        if ((itemVersion = this.getItemVersion()) != null) {
            builder.addOptionWithArgument("iv", itemVersion);
        }
        if ((mbo = this.getMainJobOnly()) != null) {
            builder.addOptionWithArgument("im", mbo);
        }
        return builder.toString();
    }

    public String getItemId() {
        if (this.itemId != null) {
            return this.itemId;
        }
        return (String)this.getValue("ITEM_ID");
    }

    public String getItemVersion() {
        if (this.version != null) {
            return this.version;
        }
        return (String)this.getValue("ITEM_VERSION");
    }

    public String getMainJobOnly() {
        if (this.mainJobOnly != null) {
            return this.mainJobOnly;
        }
        return (String)this.getValue("MAIN_JOB_ONLY");
    }
}

