/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.apache.commons.lang3.StringUtils;
import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class DetectCVECommand
extends AbstractServerCommand {
    private static final boolean INCLUDE_NOT_FIXED_DEFAULT = false;
    private String cveIndexFile;
    private String cveReportFile;
    private String versionFrom;
    private String versionTo;
    private String includeNotFixed;

    public DetectCVECommand() {
    }

    public DetectCVECommand(String cveIndexFile, String cveReportFile, String versionFrom, String versionTo, String includeNotFixed) {
        this.cveIndexFile = cveIndexFile;
        this.cveReportFile = cveReportFile;
        this.versionFrom = versionFrom;
        this.versionTo = versionTo;
        this.includeNotFixed = includeNotFixed;
    }

    public String getCveDataBaseFile() {
        return (String)this.getValue("CVE_INDEX_FILE");
    }

    public String getReportFile() {
        return (String)this.getValue("REPORT_FILE");
    }

    public String getFromVersion() {
        return (String)this.getValue("FROM_VERSION");
    }

    public String getToVersion() {
        return (String)this.getValue("TO_VERSION");
    }

    public boolean includeNotFixed() {
        if (this.getValue("INCLUDE_NOT_FIXED") == null) {
            return false;
        }
        return Boolean.valueOf((String)this.getValue("INCLUDE_NOT_FIXED"));
    }

    @Override
    public String writeToString() {
        CommandStringBuilder builder = new CommandStringBuilder("detectCVE");
        if (!StringUtils.isEmpty((CharSequence)this.cveIndexFile)) {
            builder.addOptionWithArgument("ci", StringUtils.trim((String)this.cveIndexFile));
        }
        if (!StringUtils.isEmpty((CharSequence)this.cveReportFile)) {
            builder.addOptionWithArgument("rf", StringUtils.trim((String)this.cveReportFile));
        }
        if (!StringUtils.isEmpty((CharSequence)this.versionFrom)) {
            builder.addOptionWithArgument("from", StringUtils.trim((String)this.versionFrom));
        }
        if (!StringUtils.isEmpty((CharSequence)this.versionTo)) {
            builder.addOptionWithArgument("to", StringUtils.trim((String)this.versionTo));
        }
        if (!StringUtils.isEmpty((CharSequence)this.includeNotFixed)) {
            builder.addOptionWithArgument("inf", StringUtils.trim((String)this.includeNotFixed));
        }
        return builder.toString();
    }
}

