/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import org.talend.commandline.client.CommandLineJavaCLientException;
import org.talend.commandline.client.CommandLineJavaServerException;
import org.talend.commandline.client.command.CommandStatus;
import org.talend.commandline.client.model.CommandLineCommandBean;
import org.talend.commandline.client.model.EProtocolResponse;
import org.talend.commandline.client.util.Base64SerializationHelper;
import org.talend.commandline.client.util.FileTransferHandler;
import org.talend.commandline.client.util.ReaderWriterHandler;

public class ResponseInterpreter {
    private boolean begin = false;
    private boolean end = false;
    private int addedCommandId;
    private CommandLineJavaServerException exception;
    private CommandStatus commandStatus;
    private CommandLineCommandBean[] commandlineCommandBeans;
    private String resultString;
    private String localPath;
    private long size;

    public int getAddedCommandId() {
        return this.addedCommandId;
    }

    public void setFilePath(String localPath) {
        this.localPath = localPath;
    }

    public CommandLineJavaServerException getException() {
        return this.exception;
    }

    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    public CommandLineCommandBean[] getCommandlineCommandBeans() {
        return this.commandlineCommandBeans;
    }

    public String getResultString() {
        return this.resultString;
    }

    public void parse(InputStream inputStream) throws IOException, CommandLineJavaCLientException {
        while (!this.end) {
            WithoutCrLfReaderWriterHandler readerWriterHandler = new WithoutCrLfReaderWriterHandler(inputStream);
            readerWriterHandler.readUntil('\n');
            this.parse(readerWriterHandler.getResult(), inputStream);
        }
    }

    private void parse(String string, InputStream inputStream) throws CommandLineJavaCLientException {
        if (string == null) {
            throw new CommandLineJavaCLientException("No response from server");
        }
        if (string.equals("talend> ")) {
            return;
        }
        if (string.equals(EProtocolResponse.BEGIN.getName())) {
            this.begin = true;
            return;
        }
        if (this.begin) {
            if (string.equals(EProtocolResponse.END.getName())) {
                this.end = true;
                return;
            }
            if (string.startsWith(EProtocolResponse.ADDED_COMMAND.getName())) {
                string = string.substring(EProtocolResponse.ADDED_COMMAND.getName().length() + 1);
                this.addedCommandId = Integer.parseInt(string);
                return;
            }
            if (string.startsWith(EProtocolResponse.BAD_REQUEST.getName())) {
                string = string.substring(EProtocolResponse.BAD_REQUEST.getName().length() + 1);
                this.exception = new CommandLineJavaServerException(string);
                return;
            }
            if (string.startsWith(EProtocolResponse.COMMAND_STATUS.getName())) {
                string = string.substring(EProtocolResponse.COMMAND_STATUS.getName().length() + 1);
                try {
                    this.commandStatus = (CommandStatus)new Base64SerializationHelper().decode(string, CommandStatus.class);
                }
                catch (Exception e) {
                    throw new CommandLineJavaCLientException(e);
                }
                return;
            }
            if (string.startsWith(EProtocolResponse.LIST_COMMAND.getName())) {
                string = string.substring(EProtocolResponse.LIST_COMMAND.getName().length() + 1);
                try {
                    ArrayList beanList = (ArrayList)new Base64SerializationHelper().decode(string, new Class[0]);
                    this.commandlineCommandBeans = beanList.toArray(new CommandLineCommandBean[0]);
                }
                catch (Exception e) {
                    throw new CommandLineJavaCLientException(e);
                }
                return;
            }
            if (string.startsWith(EProtocolResponse.STRING.getName())) {
                this.resultString = string.substring(EProtocolResponse.STRING.getName().length() + 1);
                return;
            }
            if (string.startsWith(EProtocolResponse.FILE_SIZE.getName())) {
                this.size = Long.parseLong(string.substring(EProtocolResponse.FILE_SIZE.getName().length() + 1));
                return;
            }
            if (string.equals(EProtocolResponse.FILE_CONTENT.getName())) {
                try {
                    FileTransferHandler.receiveFile(this.localPath, inputStream, this.size);
                    this.resultString = FileTransferHandler.getMD5(this.localPath);
                }
                catch (Exception e) {
                    throw new CommandLineJavaCLientException(e);
                }
                return;
            }
            if (string.startsWith(EProtocolResponse.FILE_MD5.getName())) {
                if (!this.resultString.equals(string.substring(EProtocolResponse.FILE_MD5.getName().length() + 1))) {
                    throw new CommandLineJavaCLientException("Bad md5");
                }
                return;
            }
        }
        throw new CommandLineJavaCLientException("unable to parse " + string);
    }

    static class WithoutCrLfReaderWriterHandler
    extends ReaderWriterHandler {
        public WithoutCrLfReaderWriterHandler(InputStream inputStream) {
            super(inputStream, new StringWriter());
        }

        @Override
        public void appendChar(char readChar) throws IOException {
            if ('\n' != readChar && '\r' != readChar) {
                super.appendChar(readChar);
            }
        }
    }
}

