/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.talend.jobbuilder.JobBuilder;
import org.talend.utils.io.FilesUtils;

@Mojo(name="install", requiresProject=false)
public class CmdlineInstaller
extends JobBuilder {
    @Parameter(required=false, property="workspace")
    protected String workSpace;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((CharSequence)this.workSpace)) {
            this.workSpace = new File("").getAbsolutePath();
        }
        this.commandlineWorkspace = this.workSpace;
        this.getLog().info((CharSequence)("commandlineWorkspace: " + new File(this.commandlineWorkspace).getAbsolutePath()));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        if (StringUtils.isBlank((CharSequence)this.p2Origin) && StringUtils.isBlank((CharSequence)this.updatesitePath)) {
            throw new MojoFailureException("talend.studio.p2.base is required.");
        }
        this.installerClean = true;
        this.installCommandline();
        String userKeyPath = this.session.getUserProperties().getProperty("studio.encryption.keys.file");
        if (StringUtils.isNotBlank((CharSequence)userKeyPath)) {
            this.getLog().info((CharSequence)"Resolve encryption key file...");
            File source = new File(userKeyPath);
            if (!source.exists()) {
                this.getLog().error((CharSequence)("File doesn't exist: " + userKeyPath));
            } else {
                File target = new File(StringUtils.stripEnd((String)this.productPath, (String)"/") + "/configuration/studio.keys");
                if (target.exists()) {
                    target.delete();
                }
                try {
                    this.getLog().debug((CharSequence)("Transfer from: " + source + " to: " + target.getAbsolutePath()));
                    FilesUtils.copyFile(source, target);
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
        this.getLog().info((CharSequence)"*****************************************************");
    }
}

