/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;

public class PomFinder
extends SimpleFileVisitor<Path> {
    private static DefaultModelBuilderFactory BUILDER_FACTORY = new DefaultModelBuilderFactory();
    private static ModelBuilder BUILDER = BUILDER_FACTORY.newInstance();
    private List<MavenProject> mavenProjects = new ArrayList<MavenProject>();
    private Log logger;

    public PomFinder(Log logger) {
        this.logger = logger;
    }

    public List<MavenProject> getSortedProjects() {
        try {
            ProjectSorter ps = new ProjectSorter(this.mavenProjects);
            return ps.getSortedProjects();
        }
        catch (CycleDetectedException e) {
            this.logger.error((Throwable)e);
        }
        catch (DuplicateProjectException e) {
            this.logger.error((Throwable)e);
        }
        return new ArrayList<MavenProject>();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (StringUtils.equals((CharSequence)"pom.xml", (CharSequence)FilenameUtils.getName((String)file.toFile().getName()))) {
            try {
                DefaultModelBuildingRequest mbr = new DefaultModelBuildingRequest();
                mbr.setPomFile(file.toFile());
                ModelBuildingResult res = BUILDER.build((ModelBuildingRequest)mbr);
                if (!res.getProblems().isEmpty()) {
                    for (ModelProblem p : res.getProblems()) {
                        this.logger.info((CharSequence)("prolem: " + p.toString() + " for " + file));
                    }
                }
                Model model = res.getEffectiveModel();
                MavenProject mp = new MavenProject(model);
                this.mavenProjects.add(mp);
                this.logger.info((CharSequence)("add maven project: " + model));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

