/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.talend.ci.util.Utils;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.Run;
import org.talend.jobbuilder.model.BundleInfo;
import org.talend.jobbuilder.model.EPlatform;
import org.talend.jobbuilder.model.ERuntimeError;

class RunInstall
extends Run {
    private boolean isRemoteUpdatesite;

    RunInstall(JobBuilder mojo) {
        super(mojo);
        this.isRemoteUpdatesite = mojo.liteP2Origin != null && mojo.liteP2Origin.toLowerCase().startsWith("http");
    }

    @Override
    Run.Result doRun() throws MojoExecutionException, MojoFailureException {
        try {
            this.cleanInstallation();
            Run.Result result = Run.Result.SUCCESS;
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"-----------------------------------------------------");
            this.logger.info((CharSequence)"Start to install Commandline...");
            this.initP2Plugins();
            result = this.resolveFromUpdateSite();
            this.logger.info((CharSequence)"");
            this.mojo.setupComponentNexusProperties();
            this.resolveEclipseProductFile();
            this.resolveLicense();
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Commandline installation finished.");
            this.logger.info((CharSequence)"-----------------------------------------------------");
            return result;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException("Commandline installation failed: ", (Throwable)e);
        }
    }

    @Override
    List<ERuntimeError> getErrorsToCheck() {
        return ERuntimeError.getErrorsForP2Install();
    }

    @Override
    String getApplication() {
        return "org.eclipse.equinox.p2.director";
    }

    @Override
    File getExecDir() {
        return new File(this.mojo.p2InstallerPath);
    }

    @Override
    List<String> getExecutionCommand() throws MojoFailureException {
        ArrayList<String> commandList = new ArrayList<String>();
        String classpath = new File(this.mojo.p2InstallerPath).toPath().resolve("plugins").resolve("org.eclipse.equinox.launcher_1.6.200.v20210416-2027.jar").normalize().toString();
        commandList.add("java");
        this.addAdditionalProperties(this.mojo.jvmArguments, commandList);
        this.addArrangedProperties("install", true, commandList);
        if (this.mojo.debug) {
            commandList.add("-Xdebug");
            commandList.add("-agentlib:jdwp=server=y,transport=dt_socket,suspend=y,address=9195");
        }
        commandList.add("-cp");
        commandList.add(classpath);
        commandList.add("org.eclipse.core.launcher.Main");
        commandList.add("-application");
        commandList.add(this.getApplication());
        commandList.add("-consolelog");
        if (!StringUtils.isEmpty((String)this.mojo.keyRingPath)) {
            commandList.add("-eclipse.keyring");
            commandList.add(this.mojo.keyRingPath);
        }
        if (!StringUtils.isEmpty((String)this.mojo.masterKeyPath)) {
            commandList.add("-eclipse.password");
            commandList.add(this.mojo.masterKeyPath);
        }
        if (!StringUtils.isEmpty((String)this.mojo.eclipseDebug)) {
            commandList.add("-debug");
            commandList.add(this.mojo.eclipseDebug);
        }
        commandList.add("-installIU");
        commandList.add("org.talend.studio.lite.ci.product,org.talend.lite.builtin.feature.feature.group,org.talend.lite.branding.feature.feature.group");
        commandList.add("-repository");
        try {
            commandList.add(this.getRepositories());
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to get P2 repositories.", (Throwable)e);
        }
        commandList.add("-destination");
        commandList.add(new File(this.mojo.productPath).toPath().normalize().toString());
        commandList.add("-tag");
        commandList.add("cmdline");
        commandList.add("-profile");
        commandList.add("profile");
        commandList.add("-profileProperties");
        commandList.add("org.eclipse.update.install.features=true");
        commandList.add("-roaming");
        EPlatform platform = EPlatform.getPlatformInfo(this.mojo.targetOs);
        commandList.add("-p2.os");
        commandList.add(platform.getOs());
        commandList.add("-p2.ws");
        commandList.add(platform.getWs());
        return commandList;
    }

    private void resolveEclipseProductFile() throws Exception {
        File targetFile = new File(this.mojo.productPath).toPath().resolve(".eclipseproduct").toFile();
        if (targetFile.exists()) {
            return;
        }
        this.logger.info((CharSequence)"Resolve .eclipseproduct file...");
        String source = this.isRemoteUpdatesite ? StringUtils.stripEnd((String)this.mojo.liteP2Origin, (String)"/") + "/" + ".eclipseproduct" : new File(this.mojo.liteP2Origin).toPath().resolve(".eclipseproduct").toString();
        this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.liteP2Origin));
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(targetFile);){
            properties.load(in);
        }
        properties.setProperty("name", "Talend Commandline");
        properties.setProperty("id", "org.talend.studio.lite.ci.product");
        try {
            Collection<String> patches = this.mojo.getPreparedPatchesMap().values();
            if (patches != null && !patches.isEmpty()) {
                String latestVersion = this.getLatestPatchVersion();
                if (StringUtils.isBlank((String)latestVersion)) {
                    this.logger.error((Throwable)new Exception("No patch version defination found in patch"));
                } else {
                    properties.setProperty("version", latestVersion);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        var5_6 = null;
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            properties.store(out, "");
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
    }

    private void updateP2Cache() throws MojoFailureException, MojoExecutionException {
        String path = null;
        try {
            String latestPathVersion = this.getLatestPatchVersion();
            if (latestPathVersion != null) {
                path = this.mojo.getPreparedPatchesMap().get(latestPathVersion);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        if (path != null) {
            String contentJar = StringUtils.stripEnd((String)path, (String)"/") + "/" + "content.jar";
            File targetFile = new File(this.mojo.productPath, "configuration/talend/studioLite/metadata/updates/content.jar");
            if (targetFile.exists()) {
                targetFile.delete();
            }
            this.mojo.transferFile(contentJar, targetFile, this.mojo.getP2UserAndPwd(this.mojo.getOneP2UpdateUrl()));
        }
    }

    private String getLatestPatchVersion() throws Exception {
        Optional optional = this.mojo.getPreparedPatchesMap().keySet().stream().sorted((v1, v2) -> v2.compareTo((String)v1)).findFirst();
        if (optional.isPresent()) {
            return (String)optional.get();
        }
        return null;
    }

    private void resolveLicense() throws Exception {
        if (this.mojo.licensePath == null) {
            return;
        }
        File target = new File(this.mojo.productPath).toPath().resolve("license").toFile();
        if (target.exists()) {
            target.delete();
        }
        String[] userAndPwd = null;
        if (this.mojo.licenseUser != null && this.mojo.licensePassword != null) {
            userAndPwd = new String[]{this.mojo.licenseUser, this.mojo.decrypt("license.remote.password", this.mojo.licensePassword)};
        }
        this.logger.info((CharSequence)"Resolve license...");
        this.mojo.transferFile(this.mojo.licensePath, target, userAndPwd);
    }

    private void initP2Plugins() throws Exception {
        Object sourcePath;
        File configIniFile = new File(StringUtils.stripEnd((String)this.mojo.p2InstallerPath, (String)"/") + "/configuration/config.ini");
        if (configIniFile.exists()) {
            return;
        }
        this.logger.info((CharSequence)"");
        this.logger.info((CharSequence)"Init P2Installer plugins...");
        URL bundlesInfoURL = RunInstall.class.getClassLoader().getResource("p2installer/bundles.info");
        File bundleInfoFile = new File(StringUtils.stripEnd((String)this.mojo.p2InstallerPath, (String)"/") + "/configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.mojo.transferFile(bundlesInfoURL, bundleInfoFile, this.mojo.getP2UserAndPwd(null));
        LinkedHashSet<BundleInfo> bundleList = new LinkedHashSet<BundleInfo>();
        try (BufferedReader reader = new BufferedReader(new FileReader(bundleInfoFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                BundleInfo bundleInfo = new BundleInfo(line);
                bundleList.add(bundleInfo);
            }
        }
        this.logger.info((CharSequence)"Get P2Installer plugins from updatesite...");
        String targetFolder = StringUtils.stripEnd((String)this.mojo.p2InstallerPath, (String)"/") + "/plugins";
        if (this.isRemoteUpdatesite) {
            sourcePath = StringUtils.stripEnd((String)this.mojo.liteP2Origin, (String)"/") + "/plugins/";
            for (BundleInfo bundleInfo : bundleList) {
                String bundleName = bundleInfo.getBundleId() + "_" + bundleInfo.getBundleVersion() + ".jar";
                String source = (String)sourcePath + bundleName;
                File targetFile = new File(targetFolder).toPath().resolve(bundleName).toFile();
                this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.liteP2Origin));
            }
        } else {
            sourcePath = new File(this.mojo.liteP2Origin).toPath().resolve("plugins").toFile();
            for (BundleInfo bundleInfo : bundleList) {
                String bundleName = bundleInfo.getBundleId() + "_" + bundleInfo.getBundleVersion() + ".jar";
                String source = ((File)sourcePath).toPath().resolve(bundleName).toString();
                File targetFile = new File(targetFolder).toPath().resolve(bundleName).toFile();
                this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.liteP2Origin));
            }
        }
        this.logger.info((CharSequence)"Synchronize P2Installer configration files...");
        URL configURL = RunInstall.class.getClassLoader().getResource("p2installer/config.ini");
        this.mojo.transferFile(configURL, configIniFile, this.mojo.getP2UserAndPwd(this.mojo.liteP2Origin));
    }

    private Run.Result resolveFromUpdateSite() throws Exception {
        File configIniFile = new File(StringUtils.stripEnd((String)this.mojo.productPath, (String)"/") + "/configuration/config.ini");
        if (configIniFile.exists()) {
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Found existing installation, skipping...");
            return Run.Result.SKIPPED;
        }
        this.updateP2Cache();
        new Run.RuntimeExecutor(this).exec();
        return Run.Result.SUCCESS;
    }

    private String getRepositories() throws Exception {
        StringBuilder repositories = new StringBuilder();
        repositories.append(Utils.formatUriStr(this.mojo.liteP2Origin));
        Collection<String> patches = this.mojo.getPreparedPatchesMap().values();
        if (patches != null && !patches.isEmpty()) {
            for (String path : patches) {
                repositories.append(",");
                repositories.append(Utils.formatUriStr(path));
            }
        }
        return repositories.toString();
    }

    private void cleanInstallation() {
        if (this.mojo.installerClean) {
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Cleaning up existing P2Installer and Commandline installation...");
            try {
                File p2InstallerDir;
                File productDir = new File(this.mojo.productPath);
                if (productDir.exists() && productDir.isDirectory()) {
                    FileUtils.cleanDirectory((File)productDir);
                }
                if ((p2InstallerDir = new File(this.mojo.p2InstallerPath)).exists() && p2InstallerDir.isDirectory()) {
                    FileUtils.cleanDirectory((File)p2InstallerDir);
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
    }
}

