/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.Run;
import org.talend.jobbuilder.model.ERuntimeError;

class RunUpgrade
extends Run {
    private static final Integer EXIT_CI_RESTART = 191;

    RunUpgrade(JobBuilder mojo) {
        super(mojo);
    }

    @Override
    Run.Result doRun() throws MojoFailureException {
        File metadata;
        if (this.mojo.installerClean && (metadata = new File(this.mojo.commandlineWorkspace, ".metadata")).exists() && metadata.isDirectory()) {
            try {
                this.logger.info((CharSequence)"");
                this.logger.info((CharSequence)"Cleaning up existing .metadata...");
                FileUtils.cleanDirectory((File)metadata);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
        this.logger.info((CharSequence)"");
        this.logger.info((CharSequence)"-----------------------------------------------------");
        this.logger.info((CharSequence)"Start to upgrade Commandline...");
        this.initLogFile();
        Run.RuntimeExecutor executor = new Run.RuntimeExecutor(this, this);
        int returnValue = executor.exec();
        while (returnValue == EXIT_CI_RESTART) {
            this.logger.info((CharSequence)"Restarting for Commandline upgrade...");
            returnValue = executor.exec();
        }
        this.logger.info((CharSequence)"Commandline upgrade finished.");
        this.logger.info((CharSequence)"-----------------------------------------------------");
        return Run.Result.SUCCESS;
    }

    @Override
    List<ERuntimeError> getErrorsToCheck() {
        return ERuntimeError.getErrorsForUpgradeCmdline();
    }

    @Override
    String getApplication() {
        return "org.talend.studiolite.p2.featmanage.UpgradeCommandlineApplication";
    }
}

