/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.talend.ci.util.VersionUtils;
import org.talend.commandline.client.command.InitLocalCommand;
import org.talend.commandline.client.command.LogoffProjectCommand;
import org.talend.commandline.client.command.LogonProjectCommand;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.RunScript;
import org.talend.jobbuilder.model.TalendProject;

@Mojo(name="executeScript", requiresProject=false)
public class ScriptExecutor
extends JobBuilder {
    @Parameter(required=false, property="workspace")
    private String workSpace;
    @Parameter(required=true, property="scriptFile")
    private String userScriptFile;
    @Parameter(required=false, property="executeRawScript", defaultValue="false")
    private boolean executeRawScript;
    @Parameter(required=false, property="projectFilter")
    protected String projectFilter;
    private File cmdFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((CharSequence)this.workSpace)) {
            this.workSpace = new File("").getAbsolutePath();
        }
        this.commandlineWorkspace = this.workSpace;
        this.getLog().info((CharSequence)("commandlineWorkspace: " + new File(this.commandlineWorkspace).getAbsolutePath()));
        this.cmdFile = new File(this.userScriptFile);
        if (!this.cmdFile.exists() || !this.cmdFile.isFile()) {
            MojoExecutionException e = new MojoExecutionException("script file can not be found: " + this.cmdFile);
            this.getLog().error((Throwable)e);
            throw e;
        }
        this.getLog().info((CharSequence)("userScriptFile: " + this.cmdFile.getAbsolutePath()));
        this.getLog().info((CharSequence)("projectFilter: " + this.projectFilter));
        this.getLog().info((CharSequence)("executeRawScript: " + this.executeRawScript));
        this.getLog().info((CharSequence)"*****************************************************");
        if (!this.executeRawScript) {
            this.initializeProjectList();
        }
        this.checkCompatiable();
        try {
            this.setConfigToCommandline();
        }
        catch (IOException e) {
            throw new MojoFailureException("Set ci-setting info failed.", (Throwable)e);
        }
        this.installCommandline();
        this.generationType = "local";
        this.executeByLocalCommandline();
    }

    @Override
    protected void checkCompatiable() throws MojoFailureException, MojoExecutionException {
        VersionUtils.create(this.getLog()).checkCompatiable((JobBuilder)this, this.commandlineWorkspace, this.productPath);
    }

    private void executeByLocalCommandline() throws MojoExecutionException, MojoFailureException {
        this.prepareLocalExcution();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Preparing to execute script");
        this.getLog().info((CharSequence)"Executing script...");
        new RunScript(this.generateScriptCommands(), this).run();
        this.getLog().info((CharSequence)"Script execution finished.");
        this.getLog().info((CharSequence)"*****************************************************");
    }

    protected List<String> loadCommandScript() throws MojoFailureException {
        ArrayList<String> cmds = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(this.cmdFile));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.endsWith(";")) {
                    line = line.substring(0, line.length() - 1);
                }
                cmds.add(line);
            }
            this.getLog().info((CharSequence)("loadCommandScript, loaded user command script file: " + this.userScriptFile));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to load user command script file", (Throwable)e);
        }
        return cmds;
    }

    protected List<String> generateScriptCommands() throws MojoFailureException {
        this.getLog().info((CharSequence)"Generating commandline script...");
        ArrayList<String> commands = new ArrayList<String>();
        List<String> userCmdLines = this.loadCommandScript();
        if (this.executeRawScript) {
            commands.addAll(userCmdLines);
        } else {
            commands.add(new InitLocalCommand().writeToString());
            ArrayList<TalendProject> targetProjects = new ArrayList<TalendProject>();
            if (StringUtils.isEmpty((CharSequence)this.projectFilter)) {
                targetProjects.addAll(this.talendProjectList);
            } else {
                Pattern p = Pattern.compile(this.projectFilter);
                for (TalendProject project : this.talendProjectList) {
                    if (!p.matcher(project.getName()).matches()) continue;
                    targetProjects.add(project);
                }
            }
            for (TalendProject project : targetProjects) {
                LogonProjectCommand logonCmd = new LogonProjectCommand(project.getName(), this.commandlineUser, null, true);
                LogoffProjectCommand logoffCmd = new LogoffProjectCommand();
                commands.add(logonCmd.writeToString());
                commands.addAll(userCmdLines);
                commands.add(logoffCmd.writeToString());
            }
        }
        return commands;
    }
}

