/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProductVersion
implements Comparable<ProductVersion> {
    private static final Pattern THREE_DIGIT_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
    private static final Pattern EXTENDED_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?.*");
    private static final Pattern FOUR_PART_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(.*)");
    private int major;
    private int minor;
    private int micro = 0;
    private boolean setMicro = false;
    private String extraInfo;
    private boolean setExtraInfo = false;

    public ProductVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.setMicro = true;
    }

    public ProductVersion(int major, int minor, int micro, String extraInfo) {
        this(major, minor, micro);
        this.extraInfo = extraInfo;
        this.setExtraInfo = true;
    }

    public ProductVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.setMicro = false;
    }

    public ProductVersion(ProductVersion productVersion, Date versionDate) {
        this(productVersion.getMajor(), productVersion.getMinor(), productVersion.getMicro(), new SimpleDateFormat("yyyyMMdd").format(versionDate));
    }

    public static ProductVersion fromString(String version, boolean extendedVersion) {
        if (!extendedVersion) {
            return ProductVersion.fromString(version);
        }
        Matcher matcher = EXTENDED_PATTERN.matcher(version);
        if (matcher.find()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String microStr = matcher.group(3);
            if (microStr != null) {
                int micro = Integer.parseInt(microStr);
                return new ProductVersion(major, minor, micro);
            }
            return new ProductVersion(major, minor);
        }
        return null;
    }

    public static ProductVersion fromString(String version, boolean extendedVersion, boolean isFourPartVersion) {
        Matcher matcher4;
        if (isFourPartVersion && (matcher4 = FOUR_PART_PATTERN.matcher(version)).find() && matcher4.groupCount() == 4) {
            int major = Integer.parseInt(matcher4.group(1));
            int minor = Integer.parseInt(matcher4.group(2));
            String microStr = matcher4.group(3);
            String extraInfo = matcher4.group(4);
            int micro = Integer.parseInt(microStr);
            return new ProductVersion(major, minor, micro, extraInfo);
        }
        return ProductVersion.fromString(version, extendedVersion);
    }

    public static ProductVersion fromString(String version) {
        Matcher matcher = THREE_DIGIT_PATTERN.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String microStr = matcher.group(3);
            int micro = Integer.parseInt(microStr);
            return new ProductVersion(major, minor, micro);
        }
        return null;
    }

    @Override
    public int compareTo(ProductVersion other) {
        int diff = this.major - other.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        if (this.setMicro && other.setMicro && (diff = this.micro - other.micro) != 0) {
            return diff;
        }
        if (this.setExtraInfo) {
            if (other.setExtraInfo) {
                return this.extraInfo.compareTo(other.extraInfo);
            }
            return 1;
        }
        if (other.setExtraInfo) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        if (this.setExtraInfo) {
            result = 31 * result + this.extraInfo.length();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductVersion other = (ProductVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return !this.setExtraInfo || !other.setExtraInfo || this.extraInfo.equals(other.extraInfo);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        stringBuilder.append(".");
        stringBuilder.append(this.minor);
        if (this.setMicro) {
            stringBuilder.append(".");
            stringBuilder.append(this.micro);
        }
        if (this.setExtraInfo) {
            stringBuilder.append(".");
            stringBuilder.append(this.extraInfo);
        }
        return stringBuilder.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean isSetMicro() {
        return this.setMicro;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public boolean isSetExtraInfo() {
        return this.setExtraInfo;
    }
}

