/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SimpleCache<K, V> {
    private Set<HashKeyValue<K, V>> keysOrderedByPutTime = new TreeSet<HashKeyValue<K, V>>();
    private Map<HashKeyValue<K, V>, HashKeyValue<K, V>> cache = new HashMap<HashKeyValue<K, V>, HashKeyValue<K, V>>();
    private Integer maxItems;
    private Long maxTime;

    public SimpleCache(long maxTime, int maxItems) {
        this.maxTime = maxTime;
        this.maxItems = maxItems;
        if (!(this.maxTime != null && this.maxTime >= 0L && this.maxTime != Long.MAX_VALUE && this.maxTime != Integer.MAX_VALUE || this.maxItems != null && this.maxItems >= 0 && this.maxItems != Integer.MAX_VALUE)) {
            throw new IllegalArgumentException("At least one of maxTime or maxItems must be a value greater or equals 0, excepted the MAX_VALUE");
        }
    }

    public synchronized V get(K key) {
        HashKeyValue internalKey = new HashKeyValue(key);
        HashKeyValue<K, V> keyValue = this.cache.get(internalKey);
        if (keyValue != null) {
            return keyValue.getValue();
        }
        return null;
    }

    public synchronized Long getAddTime(K key) {
        HashKeyValue internalKey = new HashKeyValue(key);
        HashKeyValue<K, V> keyValue = this.cache.get(internalKey);
        if (keyValue != null) {
            return keyValue.getAddTime();
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        Iterator<HashKeyValue<K, V>> setIterator;
        HashKeyValue<K, V> internalKeyValue = new HashKeyValue<K, V>(key, value);
        this.keysOrderedByPutTime.add(internalKeyValue);
        HashKeyValue<K, V> previousKeyValue = this.cache.put(internalKeyValue, internalKeyValue);
        int sizeItems = this.keysOrderedByPutTime.size();
        if (this.maxTime != null && this.maxTime >= 0L && this.maxTime != Long.MAX_VALUE && sizeItems > 0) {
            Iterator<HashKeyValue<K, V>> keysOrderedByPutTimeIterator = this.keysOrderedByPutTime.iterator();
            while (keysOrderedByPutTimeIterator.hasNext()) {
                HashKeyValue<K, V> hashKey;
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis - ((HashKeyValue)(hashKey = keysOrderedByPutTimeIterator.next())).addTime < this.maxTime) break;
                keysOrderedByPutTimeIterator.remove();
                this.cache.remove(hashKey);
            }
        }
        sizeItems = this.keysOrderedByPutTime.size();
        if (this.maxItems != null && this.maxItems >= 0 && this.maxItems != Integer.MAX_VALUE && sizeItems > this.maxItems && sizeItems > 0 && (setIterator = this.keysOrderedByPutTime.iterator()).hasNext()) {
            HashKeyValue<K, V> toRemoveFromMap = setIterator.next();
            setIterator.remove();
            this.cache.remove(toRemoveFromMap);
        }
        if (previousKeyValue != null) {
            return previousKeyValue.getValue();
        }
        return null;
    }

    public synchronized int size() {
        return this.cache.size();
    }

    protected synchronized int internalTimeListSize() {
        return this.keysOrderedByPutTime.size();
    }

    class HashKeyValue<K, V>
    implements Comparable<HashKeyValue<K, V>> {
        private K key;
        private V value;
        private long addTime;

        public HashKeyValue(K key) {
            this.key = key;
            this.addTime = System.currentTimeMillis();
        }

        public HashKeyValue(K key, V value) {
            this(key);
            this.value = value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKeyValue other = (HashKeyValue)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        @Override
        public int compareTo(HashKeyValue<K, V> o) {
            if (this.equals(o)) {
                return 0;
            }
            return this.getAddTime() < o.getAddTime() ? -1 : 1;
        }

        public V getValue() {
            return this.value;
        }

        public K getKey() {
            return this.key;
        }

        public long getAddTime() {
            return this.addTime;
        }
    }
}

