/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.dates;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class ElapsedTime {
    public static final int GREGORIAN_CAL_YEAR = 1582;
    public static final int GREGORIAN_CAL_MONTH = 10;
    public static final int GREGORIAN_CAL_DAY = 15;
    public static final double TROPICAL_YEAR_LENGTH = 365.25;
    private static final Calendar TMP_GREG_CAL_1 = new GregorianCalendar();
    private static final Calendar TMP_GREG_CAL_2 = new GregorianCalendar();
    private static final int NB_MILLIS_PER_MINUTE = 60000;
    private static final int NB_MILLIS_PER_SECOND = 1000;

    private ElapsedTime() {
    }

    public static long getNbDays(Date first, Date last) {
        Calendar c1 = TMP_GREG_CAL_1;
        Calendar c2 = TMP_GREG_CAL_2;
        c1.setTime(last);
        c2.setTime(first);
        long j1 = ElapsedTime.getJulianDays(c1.get(1), c1.get(2) + 1, c1.get(5));
        long j2 = ElapsedTime.getJulianDays(c2.get(1), c2.get(2) + 1, c2.get(5));
        long daysElapsed = j1 - j2;
        return daysElapsed;
    }

    public static long getNbMinutes(Date first, Date last) {
        long min = (last.getTime() - first.getTime()) / 60000L;
        return min;
    }

    public static long getNbSeconds(Date first, Date last) {
        long min = (last.getTime() - first.getTime()) / 1000L;
        return min;
    }

    public static long getJulianDays(int year, int month, int day) throws IllegalArgumentException {
        if (year < 1582 || year == 1582 && month < 10 || year == 1582 && month == 10 && day < 15) {
            throw new IllegalArgumentException("Dates before 15 Oct 1582 are not valid Gregorian dates " + year + "/" + month + "/" + day);
        }
        int y = year;
        int m = month;
        if (m == 1 || m == 2) {
            --y;
            m += 12;
        }
        int a = y / 100;
        int b = a / 4;
        int c = 2 - a + b;
        double e = 365.25 * (double)(y + 4716);
        double e1 = Math.floor(e);
        long e2 = Math.round(e1);
        double f = 30.6001 * (double)(m + 1);
        double f1 = Math.floor(f);
        long f2 = Math.round(f1);
        long julianDay = (long)(c + day) + e2 + f2 - 1524L;
        return julianDay;
    }

    public static int fieldDifference(Calendar start, Date endTime, int field) {
        Date startTime = start.getTime();
        if (!startTime.before(endTime)) {
            return 0;
        }
        int i = 1;
        while (true) {
            start.add(field, 1);
            if (start.getTime().after(endTime)) {
                start.add(field, -1);
                return i - 1;
            }
            ++i;
        }
    }
}

