/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.string.StringUtilities;

public class TypedProperties
extends Properties {
    private static Logger log = LoggerFactory.getLogger(TypedProperties.class);
    private static final long serialVersionUID = 2581080352306726049L;
    public static final String DEFAULT_DELIMITERS = ",";
    Set<String> anomaliesAlreadyLogged = new HashSet<String>();

    public TypedProperties() {
    }

    public TypedProperties(Properties defaults) {
        super(defaults);
    }

    public <T> boolean getBooleanValue(Class<T> clazz, String shortKey, boolean defaultValue) {
        return this.getBooleanValue(this.buildKey(clazz, shortKey), defaultValue);
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, defaultValue);
            return defaultValue;
        }
        return Boolean.parseBoolean(value.trim());
    }

    private void logWarningPropertyNotFound(String notFoundKey, Object defaultValue) {
        if (!this.anomaliesAlreadyLogged.contains(notFoundKey)) {
            this.anomaliesAlreadyLogged.add(notFoundKey);
            log.warn("!!! PROPERTY NOT FOUND !!!: the key '" + notFoundKey + "' can't be found in the JobServer properties file, the default value '" + defaultValue + "' will be used, please be sure this is not an anomaly.");
        }
    }

    public Boolean getBooleanValue(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value.trim());
    }

    public <T> long getLongValue(Class<T> clazz, String shortKey, long defaultValue) {
        return this.getLongValue(this.buildKey(clazz, shortKey), defaultValue);
    }

    public <T> double getDoubleValue(Class<T> clazz, String shortKey, double defaultValue) {
        return this.getDoubleValue(this.buildKey(clazz, shortKey), defaultValue);
    }

    public double getDoubleValue(String key, double defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, defaultValue);
            return defaultValue;
        }
        return Double.parseDouble(value.trim());
    }

    public <T> int getIntValue(Class<T> clazz, String shortKey, int defaultValue) {
        return this.getIntValue(this.buildKey(clazz, shortKey), defaultValue);
    }

    public <T> String getStringValue(Class<T> clazz, String shortKey, String defaultValue) {
        return this.getStringValue(this.buildKey(clazz, shortKey), defaultValue);
    }

    private String getStringValue(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public long getLongValue(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, defaultValue);
            return defaultValue;
        }
        return Long.parseLong(value.trim());
    }

    public int getIntValue(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, defaultValue);
            return defaultValue;
        }
        return Integer.parseInt(value.trim());
    }

    public List<String> getValues(String key, List<String> defaultValues, String delimiters) {
        String value = this.getProperty(key);
        if (value == null) {
            this.logWarningPropertyNotFound(key, String.valueOf(defaultValues));
            return defaultValues;
        }
        return StringUtilities.tokenize(value, delimiters);
    }

    public <T> List<String> getValuesWithoutWarning(Class<T> clazz, String shortKey, List<String> defaultValues) {
        String key = this.buildKey(clazz, shortKey);
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValues;
        }
        return StringUtilities.tokenize(value, DEFAULT_DELIMITERS);
    }

    public List<String> getValues(String key, List<String> defaultValues) {
        return this.getValues(key, defaultValues, DEFAULT_DELIMITERS);
    }

    public <T> List<String> getValues(Class<T> clazz, String shortKey, List<String> defaultValues) {
        return this.getValues(this.buildKey(clazz, shortKey), defaultValues, DEFAULT_DELIMITERS);
    }

    public <T> List<String> getValues(Class<T> clazz, String shortKey, List<String> defaultValues, String delimiters) {
        return this.getValues(this.buildKey(clazz, shortKey), defaultValues, delimiters);
    }

    private <T> String buildKey(Class<T> clazz, String shortKey) {
        if (clazz == null) {
            return shortKey;
        }
        return String.valueOf(clazz.getName()) + "." + shortKey;
    }

    public String logProperties(boolean all, boolean main) {
        StringBuilder builder = new StringBuilder();
        if (all) {
            builder.append("PROPERTIES: List of input properties:\n");
            Enumeration<?> names = this.propertyNames();
            ArrayList<String> namesList = new ArrayList<String>();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                namesList.add(key);
            }
            Collections.sort(namesList);
            int namesListListSize = namesList.size();
            int i = 0;
            while (i < namesListListSize) {
                String key = (String)namesList.get(i);
                String property = this.getProperty(key);
                builder.append(String.valueOf(key) + "=" + property + "\n");
                ++i;
            }
            builder.append("PROPERTIES: End of list.\n");
        }
        if (!all && main) {
            builder.append("TYPED PROPERTIES=" + this.toString());
        }
        return builder.toString();
    }
}

