/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.security.StudioKeySource;

public class StudioKeyName {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioKeySource.class);
    public static final String KEY_SYSTEM_PREFIX = "system.encryption.key.v";
    public static final String KEY_ROUTINE_PREFIX = "routine.encryption.key.v";
    public static final String KEY_SYSTEM_DEFAULT = "system.encryption.key.v1";
    public static final String KEY_ROUTINE = "routine.encryption.key.v1";
    public static final String KEY_MIGRATION_TOKEN = "migration.token.encryption.key";
    public static final String KEY_MIGRATION = "migration.encryption.key";
    public static final String KEY_MDM_ENCRYPTION = "mdm.encryption.key";
    private final String keyName;

    public StudioKeyName(String keyName) {
        this.keyName = keyName;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid key name: " + keyName);
        }
    }

    private boolean isValid() {
        if (this.keyName == null || this.keyName.isEmpty()) {
            return false;
        }
        if (this.keyName.equals(KEY_MIGRATION_TOKEN) || this.keyName.equals(KEY_MIGRATION) || KEY_MDM_ENCRYPTION.equals(this.keyName)) {
            return true;
        }
        if (!this.isRoutineKey() && !this.isSystemKey()) {
            return false;
        }
        return this.getVersionNumber() > -1;
    }

    public int getVersionNumber() {
        if ((this.isRoutineKey() || this.isSystemKey()) && this.keyName.length() > this.getKeyNamePrefix().length()) {
            int idx = this.keyName.lastIndexOf(46);
            try {
                return Integer.parseInt(this.keyName.substring(idx + 2));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Parse version of encryption key error, key: " + this.keyName);
                return -1;
            }
        }
        return 0;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isRoutineKey() {
        return this.keyName.startsWith(KEY_ROUTINE_PREFIX);
    }

    public boolean isSystemKey() {
        return this.keyName.startsWith(KEY_SYSTEM_PREFIX);
    }

    public boolean isDefaultRoutineKey() {
        return this.keyName.equals(KEY_ROUTINE);
    }

    public String getKeyNamePrefix() {
        if (this.isSystemKey()) {
            return KEY_SYSTEM_PREFIX;
        }
        if (this.isRoutineKey()) {
            return KEY_ROUTINE_PREFIX;
        }
        return "";
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof StudioKeyName)) {
            return false;
        }
        StudioKeyName thatObj = (StudioKeyName)that;
        return this.keyName.equals(thatObj.getKeyName());
    }

    public String toString() {
        return this.keyName;
    }
}

