/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.sugars.ReturnCode;

public final class ConnectionUtils {
    private static Logger log = LoggerFactory.getLogger(ConnectionUtils.class);
    private static List<String> sybaseDBProductsNames;
    public static final String IBM_DB2_ZOS_PRODUCT_NAME = "DB2";
    public static final String POSTGRESQL_PRODUCT_NAME = "POSTGRESQL";
    public static final String SYBASE_PRODUCT_NAME = "SYBASE";
    public static final String SYBASE_LANGUAGE = "Adaptive Server Enterprise | Sybase Adaptive Server IQ";
    private static final String ACCESS_DRIVER = "Microsoft Access Driver";
    public static final String SHUTDOWN_PARAM = ";shutdown=true";

    private ConnectionUtils() {
    }

    @Deprecated
    public static Connection createConnection(String url, String driverClassName, Properties props) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Driver driver = (Driver)Class.forName(driverClassName).newInstance();
        return ConnectionUtils.createConnection(url, driver, props);
    }

    @Deprecated
    public static Connection createConnection(String url, Driver driver, Properties props) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection connection = null;
        if (driver != null) {
            try {
                DriverManager.registerDriver(driver);
                Class.forName(driver.getClass().getName());
                if (ConnectionUtils.isMsSqlServer(url) || ConnectionUtils.isSybase(url) || ConnectionUtils.isHiveServer(url)) {
                    connection = driver.connect(url, props);
                }
                connection = DriverManager.getConnection(url, props);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    connection = driver.connect(url, props);
                }
                catch (Exception exception) {
                    log.info(exception.getMessage(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
            }
        } else if (ConnectionUtils.isODBCServer(url)) {
            connection = DriverManager.getConnection(url, props);
        }
        return connection;
    }

    private static boolean isODBCServer(String url) {
        return url.startsWith("jdbc:odbc:");
    }

    public static boolean isJDBCURL(String url) {
        return url != null && url.startsWith("jdbc:");
    }

    public static boolean isJDBCType(String dbType) {
        return "JDBC".equals(dbType);
    }

    public static boolean isSybase(String url) {
        return url.indexOf("sybase") > -1;
    }

    public static boolean isMsSqlServer(String url) {
        return url.indexOf("sqlserver") > -1;
    }

    public static boolean isHiveServer(String url) {
        return url.indexOf("hive") > -1;
    }

    public static boolean isHiveConnection(String url) {
        return url != null && url.startsWith("jdbc:hive");
    }

    public static boolean isAccess(String url) {
        return url != null && url.contains(ACCESS_DRIVER);
    }

    public static boolean isHsql(String url) {
        return url != null && url.startsWith("jdbc:hsqldb");
    }

    public static boolean isInProcessModeHsql(String url) {
        return url != null && url.startsWith("jdbc:hsqldb:file");
    }

    public static String addShutDownForHSQLUrl(String url, String AdditionalParams) {
        String dbUrl = url;
        if (AdditionalParams.indexOf(SHUTDOWN_PARAM) == -1) {
            dbUrl = String.valueOf(dbUrl) + SHUTDOWN_PARAM;
        }
        return dbUrl;
    }

    public static void executeShutDownForHSQL(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("SHUTDOWN;");
        statement.close();
    }

    public static boolean isServerModeHsql(String url) {
        return url != null && url.startsWith("jdbc:hsqldb:hsql");
    }

    public static boolean isTeradata(String url) {
        return url != null && url.startsWith("jdbc:teradata");
    }

    public static boolean isVertica(String url) {
        return url != null && url.startsWith("jdbc:vertica");
    }

    /*
     * Loose catch block
     */
    public static ReturnCode isValid(Connection connection) {
        ReturnCode returnCode;
        ResultSet ping;
        ReturnCode retCode;
        block17: {
            block15: {
                ReturnCode returnCode2;
                block16: {
                    retCode = new ReturnCode();
                    if (connection == null) {
                        retCode.setReturnCode("Connection is null!", false);
                        return retCode;
                    }
                    ping = null;
                    if (!connection.isClosed()) break block15;
                    retCode.setReturnCode("Connection is closed", false);
                    returnCode2 = retCode;
                    if (ping == null) break block16;
                    try {
                        ping.close();
                    }
                    catch (Exception exception) {}
                }
                return returnCode2;
            }
            connection.getAutoCommit();
            returnCode = retCode;
            if (ping == null) break block17;
            try {
                ping.close();
            }
            catch (Exception exception) {}
        }
        return returnCode;
        catch (SQLException sqle) {
            ReturnCode returnCode3;
            block18: {
                try {
                    retCode.setReturnCode("SQLException caught:" + sqle.getMessage() + " SQL error code: " + sqle.getErrorCode(), false);
                    returnCode3 = retCode;
                    if (ping == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ping != null) {
                        try {
                            ping.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    ping.close();
                }
                catch (Exception exception) {}
            }
            return returnCode3;
        }
    }

    public static ReturnCode closeConnection(Connection connection) {
        assert (connection != null);
        ReturnCode rc = new ReturnCode(true);
        try {
            try {
                String url;
                if (connection != null && !connection.isClosed() && connection.getMetaData() != null && ConnectionUtils.isInProcessModeHsql(url = connection.getMetaData().getURL())) {
                    ConnectionUtils.executeShutDownForHSQL(connection);
                }
            }
            catch (SQLException e) {
                rc.setReturnCode("Failed to close connection. Reason: " + e.getMessage(), false);
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    log.warn(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return rc;
    }

    public static boolean isSybase(Connection connection) throws SQLException {
        DatabaseMetaData connectionMetadata = connection.getMetaData();
        if (connectionMetadata.getDriverName() != null && connectionMetadata.getDatabaseProductName() != null) {
            String[] stringArray = ConnectionUtils.getSybaseDBProductsName();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyString = stringArray[n2];
                if (keyString.equals(connectionMetadata.getDatabaseProductName().trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Deprecated
    public static DatabaseMetaData getConnectionMetadata(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        if (dbMetaData != null && dbMetaData.getDatabaseProductName() != null && dbMetaData.getDatabaseProductName().equals(IBM_DB2_ZOS_PRODUCT_NAME)) {
            dbMetaData = conn.getMetaData();
            log.info("IBM DB2 for z/OS");
        }
        return dbMetaData;
    }

    public static boolean isDB2(DatabaseMetaData metadata) throws SQLException {
        return metadata != null && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().indexOf(IBM_DB2_ZOS_PRODUCT_NAME) > -1;
    }

    public static boolean isOracleForSid(DatabaseMetaData metadata, String oracleProduct) throws SQLException {
        return metadata != null && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().indexOf(oracleProduct) > -1;
    }

    public static boolean isSqlite(DatabaseMetaData metadata, String sqliteProduct) throws SQLException {
        return metadata != null && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toUpperCase().indexOf(sqliteProduct) > -1;
    }

    public static boolean isPostgresql(DatabaseMetaData metadata) {
        boolean result = false;
        try {
            if (metadata != null && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toUpperCase().indexOf(POSTGRESQL_PRODUCT_NAME) > -1) {
                result = true;
            }
        }
        catch (SQLException sQLException) {
            result = false;
        }
        return result;
    }

    public static boolean isSybase(DatabaseMetaData metadata) {
        boolean result = false;
        if (metadata != null && "org.talend.commons.utils.database.SybaseDatabaseMetaData".equals(metadata.getClass().getName())) {
            result = true;
        }
        return result;
    }

    public static boolean isSnowflake(DatabaseMetaData metadata) throws SQLException {
        return metadata != null && metadata.getDriverName() != null && metadata.getDriverName().toLowerCase().startsWith("snowflake") && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toLowerCase().startsWith("snowflake");
    }

    public static boolean isExasol(DatabaseMetaData metadata) throws SQLException {
        return metadata != null && metadata.getDriverName() != null && metadata.getDriverName().toLowerCase().startsWith("exasol") && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toLowerCase().startsWith("exasol");
    }

    public static String[] getSybaseDBProductsName() {
        if (sybaseDBProductsNames == null) {
            sybaseDBProductsNames = new ArrayList<String>();
            String[] stringArray = SYBASE_LANGUAGE.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                sybaseDBProductsNames.add(name.trim());
                ++n2;
            }
            sybaseDBProductsNames.add("Sybase");
            sybaseDBProductsNames.add("Sybase IQ");
            sybaseDBProductsNames.add(SYBASE_LANGUAGE);
        }
        return sybaseDBProductsNames.toArray(new String[sybaseDBProductsNames.size()]);
    }

    public static boolean isOdbcTeradata(DatabaseMetaData metadata) throws SQLException {
        return metadata.getDriverName() != null && metadata.getDriverName().toLowerCase().startsWith("jdbc-odbc bridge (tdata32.dll)") && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toLowerCase().indexOf("teradata") > -1;
    }

    public static boolean isOdbcHyperFileSQL(DatabaseMetaData metadata) {
        try {
            return metadata.getDriverName() != null && metadata.getDriverName().toLowerCase().startsWith("jdbc-odbc bridge") && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toLowerCase().indexOf("hyperfilesql") > -1;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public static boolean isNetezza(DatabaseMetaData databaseMetaData) {
        try {
            if (databaseMetaData != null && databaseMetaData.getDriverName() != null && databaseMetaData.getDriverName().toLowerCase().startsWith("netezza") && databaseMetaData.getDatabaseProductName() != null && databaseMetaData.getDatabaseProductName().toLowerCase().startsWith("netezza")) {
                return true;
            }
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isMysql(DatabaseMetaData metadata) throws SQLException {
        boolean result = false;
        try {
            if (metadata != null && metadata.getDriverName() != null && metadata.getDatabaseProductName() != null && metadata.getDatabaseProductName().toUpperCase().indexOf("MYSQL") > -1) {
                result = true;
            }
        }
        catch (SQLException sQLException) {
            result = false;
        }
        return result;
    }
}

