/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.sql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class TalendTypeConvert {
    private static Map<String, Integer> map;
    private static String idStr;

    static {
        idStr = "id_";
    }

    private TalendTypeConvert() {
    }

    private static Map<String, Integer> getMap() {
        if (map == null) {
            map = new HashMap<String, Integer>();
            map.put(TalendTypeConvert.talendTypeName(Boolean.class), 16);
            map.put(TalendTypeConvert.talendTypeName(Byte.class), 3);
            map.put(TalendTypeConvert.talendTypeName(Character.class), 1);
            map.put(TalendTypeConvert.talendTypeName(Date.class), 91);
            map.put(TalendTypeConvert.talendTypeName(String.class), 2005);
            map.put(TalendTypeConvert.talendTypeName(Double.class), 8);
            map.put(TalendTypeConvert.talendTypeName(Float.class), 6);
            map.put(TalendTypeConvert.talendTypeName(Integer.class), 4);
            map.put(TalendTypeConvert.talendTypeName(Long.class), 4);
            map.put(TalendTypeConvert.talendTypeName(Short.class), 5);
        }
        return map;
    }

    private static String talendTypeName(Class<?> nullableClass) {
        return String.valueOf(idStr) + nullableClass.getSimpleName();
    }

    public static int convertToJDBCType(String talendType) {
        Integer type = TalendTypeConvert.getMap().get(talendType);
        return type == null ? 0 : type;
    }

    public static Object convertToObject(String talendType, String value, String datePattern) {
        Object object = null;
        value = value.trim();
        value = StringUtils.remove((String)value, (String)"\r");
        value = StringUtils.remove((String)value, (String)"\n");
        try {
            if (talendType.equals(TalendTypeConvert.talendTypeName(Boolean.class))) {
                object = (boolean)Boolean.valueOf(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Byte.class))) {
                object = (byte)Byte.valueOf(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Date.class))) {
                datePattern = datePattern == null || "".equals(datePattern.trim()) ? "yyyy-MM-dd" : StringUtils.replace((String)datePattern, (String)"\"", (String)"");
                SimpleDateFormat sdf = new SimpleDateFormat(datePattern, Locale.US);
                object = sdf.parse(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Double.class))) {
                object = Double.parseDouble(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Float.class))) {
                object = Float.valueOf(Float.parseFloat(value));
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Integer.class))) {
                object = Integer.parseInt(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Long.class))) {
                object = Long.parseLong(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(Short.class))) {
                object = Short.parseShort(value);
            } else if (talendType.equals(TalendTypeConvert.talendTypeName(String.class)) || talendType.equals(TalendTypeConvert.talendTypeName(Character.class))) {
                object = value;
            }
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    public static String convertToJavaType(String talendType) {
        if (talendType == null) {
            return "";
        }
        talendType = StringUtils.remove((String)talendType, (String)idStr);
        return talendType;
    }
}

