/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.ssl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtils {
    public static final String TAC_SSL_KEYSTORE = "clientKeystore.jks";
    public static final String TAC_SSL_TRUSTSTORE = "clientTruststore.jks";
    public static final String TAC_SSL_CLIENT_KEY = "tac.net.ssl.ClientKeyStore";
    public static final String TAC_SSL_CLIENT_TRUST_KEY = "tac.net.ssl.ClientTrustStore";
    public static final String TAC_SSL_KEYSTORE_PASS = "tac.net.ssl.KeyStorePass";
    public static final String TAC_SSL_TRUSTSTORE_PASS = "tac.net.ssl.TrustStorePass";
    public static final String TAC_SSL_ENABLE_HOST_NAME_VERIFICATION = "tac.net.ssl.EnableHostNameVerification";
    public static final String TAC_SSL_ACCEPT_ALL_CERTS_IF_NO_TRUSTSTORE = "tac.net.ssl.AcceptAllCertsIfNoTruststore";
    private HostnameVerifier hostnameVerifier;
    private KeyManager[] keystoreManagers;
    private TrustManager[] truststoreManagers;
    private static Map<String, SSLUtils> userDirToInstanceMap = new HashMap<String, SSLUtils>();

    public static synchronized SSLUtils getInstance(String userDir) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, FileNotFoundException, IOException {
        if (userDir == null) {
            userDir = "";
        }
        if (userDirToInstanceMap.containsKey(userDir)) {
            return userDirToInstanceMap.get(userDir);
        }
        SSLUtils newInstance = new SSLUtils(userDir);
        userDirToInstanceMap.put(userDir, newInstance);
        return newInstance;
    }

    private SSLUtils(String userDir) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, FileNotFoundException, IOException {
        this.Init(userDir);
    }

    private void Init(String userDir) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException {
        boolean enableHostnameVerification;
        TrustManagerFactory tmf;
        File trustStorePathFile;
        File keystorePathFile;
        String keystorePath = System.getProperty(TAC_SSL_CLIENT_KEY);
        String trustStorePath = System.getProperty(TAC_SSL_CLIENT_TRUST_KEY);
        String keystorePass = System.getProperty(TAC_SSL_KEYSTORE_PASS);
        String truststorePass = System.getProperty(TAC_SSL_TRUSTSTORE_PASS);
        boolean acceptAllCertsIfNoTrustStore = Boolean.parseBoolean(System.getProperty(TAC_SSL_ACCEPT_ALL_CERTS_IF_NO_TRUSTSTORE));
        if (keystorePath == null && (keystorePathFile = new File(String.valueOf(userDir) + TAC_SSL_KEYSTORE)).exists()) {
            keystorePath = keystorePathFile.getAbsolutePath();
        }
        if (trustStorePath == null && (trustStorePathFile = new File(String.valueOf(userDir) + TAC_SSL_TRUSTSTORE)).exists()) {
            trustStorePath = trustStorePathFile.getAbsolutePath();
        }
        if (keystorePass == null) {
            keystorePass = "";
        }
        if (truststorePass == null) {
            truststorePass = "";
        }
        if (keystorePath != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(new FileInputStream(keystorePath), keystorePass == null ? null : keystorePass.toCharArray());
            kmf.init(ks, keystorePass == null ? null : keystorePass.toCharArray());
            this.keystoreManagers = kmf.getKeyManagers();
        }
        if (trustStorePath != null) {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore tks = KeyStore.getInstance(KeyStore.getDefaultType());
            tks.load(new FileInputStream(trustStorePath), truststorePass.toCharArray());
            tmf.init(tks);
            this.truststoreManagers = tmf.getTrustManagers();
        }
        if (this.truststoreManagers == null) {
            if (acceptAllCertsIfNoTrustStore) {
                this.truststoreManagers = new TrustManager[]{new TrustAnyTrustManager()};
            } else {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                this.truststoreManagers = tmf.getTrustManagers();
            }
        }
        this.hostnameVerifier = (enableHostnameVerification = Boolean.parseBoolean(System.getProperty(TAC_SSL_ENABLE_HOST_NAME_VERIFICATION, Boolean.TRUE.toString()))) ? new BrowserCompatibleHostnameVerifier() : new AllowAllHostnameVerifier();
    }

    public SSLContext getSSLContext() throws Exception {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(this.keystoreManagers, this.truststoreManagers, null);
        return sslcontext;
    }

    public static SSLContext getSSLContext(String userDir) throws Exception {
        SSLUtils instance = SSLUtils.getInstance(userDir);
        return instance.getSSLContext();
    }

    public static String getContent(StringBuffer buffer, URL url, String userDir) throws Exception {
        SSLUtils instance = SSLUtils.getInstance(userDir);
        return instance.getContent(buffer, url);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getContent(StringBuffer buffer, URL url) throws Exception {
        String inputLine;
        BufferedReader in = null;
        if ("https".equals(url.getProtocol())) {
            SSLSocketFactory socketFactory = this.getSSLContext().getSocketFactory();
            HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
            httpsCon.setSSLSocketFactory(socketFactory);
            httpsCon.setHostnameVerifier(this.hostnameVerifier);
            httpsCon.connect();
            in = new BufferedReader(new InputStreamReader(httpsCon.getInputStream()));
        } else {
            in = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        while ((inputLine = in.readLine()) != null) {
            buffer.append(inputLine);
        }
        in.close();
        return buffer.toString();
    }

    private class AllowAllHostnameVerifier
    implements HostnameVerifier {
        private AllowAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class BrowserCompatibleHostnameVerifier
    implements HostnameVerifier {
        private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
        private static final char COLON_CHAR = ':';
        private static final int MAX_COLON_COUNT = 7;

        private BrowserCompatibleHostnameVerifier() {
        }

        @Override
        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certs = session.getPeerCertificates();
                X509Certificate x509 = (X509Certificate)certs[0];
                this.verify(host, x509);
                return true;
            }
            catch (SSLException sSLException) {
                return false;
            }
        }

        private void verify(String host, X509Certificate cert) throws SSLException {
            String[] cns = this.getCNs(cert);
            String[] subjectAlts = this.getSubjectAlts(cert, host);
            this.verify(host, cns, subjectAlts);
        }

        private void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            this.verify(host, cns, subjectAlts, false);
        }

        private void verify(String host, String[] cns, String[] subjectAlts, boolean strictWithSubDomains) throws SSLException {
            LinkedList<String> names = new LinkedList<String>();
            if (cns != null && cns.length > 0 && cns[0] != null) {
                names.add(cns[0]);
            }
            if (subjectAlts != null) {
                String[] stringArray = subjectAlts;
                int n = subjectAlts.length;
                int n2 = 0;
                while (n2 < n) {
                    String subjectAlt = stringArray[n2];
                    if (subjectAlt != null) {
                        names.add(subjectAlt);
                    }
                    ++n2;
                }
            }
            if (names.isEmpty()) {
                String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
                throw new SSLException(msg);
            }
            StringBuilder buf = new StringBuilder();
            String hostName = host.trim().toLowerCase(Locale.US);
            boolean match = false;
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String[] parts;
                boolean doWildcard;
                String cn = (String)it.next();
                cn = cn.toLowerCase(Locale.US);
                buf.append(" <");
                buf.append(cn);
                buf.append('>');
                if (it.hasNext()) {
                    buf.append(" OR");
                }
                boolean bl = doWildcard = (parts = cn.split("\\.")).length >= 3 && parts[0].endsWith("*") && this.acceptableCountryWildcard(cn) && !this.isIPAddress(host);
                if (doWildcard) {
                    String firstpart = parts[0];
                    if (firstpart.length() > 1) {
                        String prefix = firstpart.substring(0, firstpart.length() - 1);
                        String suffix = cn.substring(firstpart.length());
                        String hostSuffix = hostName.substring(prefix.length());
                        match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
                    } else {
                        match = hostName.endsWith(cn.substring(1));
                    }
                    if (match && strictWithSubDomains) {
                        match = this.countDots(hostName) == this.countDots(cn);
                    }
                } else {
                    match = hostName.equals(cn);
                }
                if (match) break;
            }
            if (!match) {
                throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
            }
        }

        private String[] getCNs(X509Certificate cert) {
            LinkedList<String> cnList = new LinkedList<String>();
            String subjectPrincipal = cert.getSubjectX500Principal().toString();
            StringTokenizer st = new StringTokenizer(subjectPrincipal, ",+");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() <= 3 || !tok.substring(0, 3).equalsIgnoreCase("CN=")) continue;
                cnList.add(tok.substring(3));
            }
            if (!cnList.isEmpty()) {
                String[] cns = new String[cnList.size()];
                cnList.toArray(cns);
                return cns;
            }
            return null;
        }

        private boolean acceptableCountryWildcard(String cn) {
            String[] parts = cn.split("\\.");
            if (parts.length != 3 || parts[2].length() != 2) {
                return true;
            }
            return Arrays.binarySearch(BAD_COUNTRY_2LDS, parts[1]) < 0;
        }

        private boolean isIPAddress(String hostname) {
            return hostname != null && (this.isIPv4Address(hostname) || this.isIPv6Address(hostname));
        }

        private boolean isIPv4Address(String input) {
            return IPV4_PATTERN.matcher(input).matches();
        }

        private boolean isIPv6Address(String input) {
            return this.isIPv6StdAddress(input) || this.isIPv6HexCompressedAddress(input);
        }

        private boolean isIPv6StdAddress(String input) {
            return IPV6_STD_PATTERN.matcher(input).matches();
        }

        private boolean isIPv6HexCompressedAddress(String input) {
            int colonCount = 0;
            int i = 0;
            while (i < input.length()) {
                if (input.charAt(i) == ':') {
                    ++colonCount;
                }
                ++i;
            }
            return colonCount <= 7 && IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
        }

        private int countDots(String s) {
            int count = 0;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == '.') {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        private String[] getSubjectAlts(X509Certificate cert, String hostname) {
            int subjectType = this.isIPAddress(hostname) ? 7 : 2;
            LinkedList<String> subjectAltList = new LinkedList<String>();
            Collection<List<?>> c = null;
            try {
                c = cert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {}
            if (c != null) {
                for (List<?> aC : c) {
                    List<?> list = aC;
                    int type = (Integer)list.get(0);
                    if (type != subjectType) continue;
                    String s = (String)list.get(1);
                    subjectAltList.add(s);
                }
            }
            if (!subjectAltList.isEmpty()) {
                String[] subjectAlts = new String[subjectAltList.size()];
                subjectAltList.toArray(subjectAlts);
                return subjectAlts;
            }
            return null;
        }
    }

    private class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

