/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.string;

import org.apache.commons.lang3.StringEscapeUtils;

public class StudioContextUtils {
    public static final String QUOTATION_MARK = "\"";

    private StudioContextUtils() {
    }

    public static String encodeValue(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        String result = StudioContextUtils.removeQuotes(value, QUOTATION_MARK);
        if (length > 1 && (value.startsWith(QUOTATION_MARK) && value.endsWith(QUOTATION_MARK) || value.startsWith("'") && value.endsWith("'")) && (result = value.substring(1, length - 1)).contains("\\")) {
            result = result.replaceAll("\\\\n", "\n");
            result = result.replaceAll("\\\\b", "\b");
            result = result.replaceAll("\\\\f", "\f");
            result = result.replaceAll("\\\\r", "\r");
            result = result.replaceAll("\\\\t", "\t");
            result = result.replaceAll("\\\\\"", QUOTATION_MARK);
            if ((result = result.replaceAll("\\\\\\\\", "\\\\")).contains("\\u")) {
                int indexStart = 0;
                while (result.indexOf("\\u", indexStart) >= 0) {
                    if (result.indexOf("\\u", indexStart) + 5 <= result.length()) {
                        int unicodeStart = result.indexOf("\\u");
                        int unicodeEnd = unicodeStart + 5;
                        result = result.substring(0, Math.max(0, unicodeStart)) + StringEscapeUtils.unescapeJava((String)result.substring(unicodeStart, unicodeEnd + 1)) + result.substring(Math.min(unicodeEnd + 1, result.length()), result.length());
                    }
                    indexStart = result.indexOf("\\u", indexStart);
                }
            }
        }
        return result;
    }

    public static String removeQuotes(String text, String quotation) {
        if (text == null) {
            return null;
        }
        if (text.length() > 1) {
            String substring = text.substring(0, 1);
            if (quotation.equals(substring)) {
                text = text.substring(1, text.length());
            }
            if (quotation.equals(substring = text.substring(text.length() - 1, text.length()))) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    public static String removeQuotesIfExist(String text, String quotation) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith(quotation)) {
            return text;
        }
        return StudioContextUtils.removeQuotes(text, quotation);
    }
}

