/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.time;

import org.slf4j.Logger;

public class TimeTracer {
    private static final int MAX = 20;
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private Logger log;
    private String name;
    private int idx = 0;
    private long[] starts = new long[20];
    private static String[] textIndentations = TimeTracer.makeTextIndentations();

    private static String[] makeTextIndentations() {
        String[] indentations = new String[20];
        String m = EMPTY;
        for (int i = 0; i < 20; ++i) {
            indentations[i] = m;
            m = m + "\t";
        }
        return indentations;
    }

    public TimeTracer(String aName, Logger aLog) {
        this.log = aLog;
        this.name = aName != null ? aName : EMPTY;
    }

    public void reset() {
        this.idx = 0;
    }

    public void start() {
        this.start(EMPTY);
    }

    public void start(String text) {
        String msg = textIndentations[this.idx];
        this.starts[this.idx] = System.currentTimeMillis();
        if (this.idx < 19) {
            ++this.idx;
        }
        if (text == null || text.length() == 0) {
            return;
        }
        msg = msg + "ZZ***B:" + this.name + SPACE + text;
        this.show(msg);
    }

    public long end(int nbTest) {
        return this.end(EMPTY, nbTest);
    }

    public long end() {
        return this.end(EMPTY, 1);
    }

    public long end(String text) {
        return this.end(text, 1);
    }

    public long end(String text, int nbTest) {
        if (this.idx > 0) {
            --this.idx;
        }
        String msg = textIndentations[this.idx];
        long beginTime = this.starts[this.idx];
        long spent = System.currentTimeMillis() - beginTime;
        msg = msg + "ZZ***E:" + this.name + SPACE;
        if (text != null && text.length() != 0) {
            msg = msg + text;
        }
        msg = nbTest >= 2 ? msg + " nbTest=" + nbTest + " spent=" + spent + " ms avg=" + spent / (long)nbTest + " begin was" + beginTime : msg + " spent=" + spent + " ms";
        this.show(msg);
        return spent;
    }

    private void show(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        } else {
            System.out.println(msg);
        }
    }
}

