/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class XmlUtils {
    public static Transformer getXmlSecureTransform() throws TransformerConfigurationException {
        Transformer transformer = XmlUtils.getXmlSecureTransformerFactory().newTransformer();
        return transformer;
    }

    public static TransformerFactory getXmlSecureTransformerFactory() {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return transFactory;
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() {
        return XmlUtils.getSecureDocumentBuilderFactory(true);
    }

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory(boolean disAllowDoctypeDecl) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (disAllowDoctypeDecl) {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return factory;
    }
}

