/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api.authentication;

import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.DefaultConfigurationValues;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.authentication.OAuth20;
import org.talend.components.common.httpclient.api.authentication.Token;
import org.talend.components.common.httpclient.factory.HTTPClientFactory;

public class OAuth20FlowExecution {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth20FlowExecution.class);
    private QueryConfiguration config;

    public OAuth20FlowExecution(QueryConfiguration config) {
        this.config = config;
    }

    public Token executeFlow() throws HTTPClientException {
        long expirationSecurityDuration;
        JsonObject jsonObject;
        long current = System.currentTimeMillis();
        HTTPClient httpClient = HTTPClientFactory.create(this.config);
        HTTPClient.HTTPResponse response = httpClient.invoke();
        String bodyAsString = response.getBodyAsString();
        try (JsonParser parser = Json.createParser((Reader)new StringReader(bodyAsString));){
            jsonObject = parser.getObject();
        }
        catch (IllegalStateException e) {
            throw new HTTPClientException(String.format("Can't parse OAuth2.0 token response as a json. Authentication status: %s", response.getStatus().getCodeWithReason()), e);
        }
        if (!response.isSuccess()) {
            String errorURI = jsonObject.containsKey((Object)OAuth20.errorToken.error_uri.name()) ? jsonObject.getString(OAuth20.errorToken.error_uri.name()) : "";
            String errorDescription = jsonObject.containsKey((Object)OAuth20.errorToken.error_description.name()) ? jsonObject.getString(OAuth20.errorToken.error_description.name()) : "";
            String error = jsonObject.containsKey((Object)OAuth20.errorToken.error.name()) ? jsonObject.getString(OAuth20.errorToken.error.name()) : "";
            throw new HTTPClientException(String.format("Failing to retrieve OAuth 2.0 token:\nstatus = %s\nerror = %s\ndescription = %s\nuri = %s", response.getStatus().getCodeWithReason(), error, errorDescription, errorURI));
        }
        String accessToken = jsonObject.getString(OAuth20.successToken.access_token.name());
        String tokenType = jsonObject.containsKey((Object)OAuth20.successToken.token_type.name()) ? jsonObject.getString(OAuth20.successToken.token_type.name()) : "Bearer";
        long expiresIn = 0L;
        if (jsonObject.containsKey((Object)OAuth20.successToken.expires_in.name())) {
            JsonValue expiresInValue = (JsonValue)jsonObject.get((Object)OAuth20.successToken.expires_in.name());
            if (expiresInValue.getValueType() == JsonValue.ValueType.STRING) {
                try {
                    expiresIn = Long.parseLong(((JsonString)expiresInValue).getString());
                }
                catch (NumberFormatException e) {
                    log.warn(String.format("The 'expires_in' attribute value in the OAUTH2 request can't be converted to long value '%s'. It will be set to 0. ", expiresInValue));
                }
            } else if (expiresInValue.getValueType() == JsonValue.ValueType.NUMBER) {
                expiresIn = ((JsonNumber)expiresInValue).longValue();
            } else {
                log.warn(String.format("The type '%s' of the 'expires_in' attribute in the OAUTH2 request is not supported.", expiresInValue.getValueType()));
            }
        }
        if (DefaultConfigurationValues.HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN_VALUE > Long.MIN_VALUE) {
            expiresIn = DefaultConfigurationValues.HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN_VALUE;
            log.info(String.format("Force expires_in value for oauth2.0 token to '%s'.", expiresIn));
        }
        if (expiresIn > (expirationSecurityDuration = DefaultConfigurationValues.HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION_VALUE)) {
            expiresIn -= expirationSecurityDuration;
        }
        if (accessToken == null) {
            throw new HTTPClientException(String.format("OAuth 2.0 %s response field is null. No token retrieved.", OAuth20.successToken.access_token.name()));
        }
        Token token = new Token(accessToken, tokenType, current / 1000L, expiresIn);
        log.info(String.format("New OAuth2.0 token retrieved from '%s'.", this.config.getUrl()));
        return token;
    }

    @Generated
    public QueryConfiguration getConfig() {
        return this.config;
    }
}

