/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api.jsondecorator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.jsondecorator.JSONDecoratorConfig;
import org.talend.components.jsondecorator.api.JsonDecoratorBuilder;
import org.talend.components.jsondecorator.impl.JsonDecoratorFactoryImpl;

public class HTTPClientWithJSONDecorator<C>
implements HTTPClient<C> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPClientWithJSONDecorator.class);
    private HTTPClient<C> client;
    private JSONDecoratorConfig jsonDecoratorConfig;

    public HTTPClientWithJSONDecorator(HTTPClient<C> client, JSONDecoratorConfig jsonDecoratorConfig) {
        this.client = client;
        this.jsonDecoratorConfig = jsonDecoratorConfig;
    }

    @Override
    public C getNestedClient() {
        return this.client.getNestedClient();
    }

    @Override
    public HTTPResponseWithJSONDecorator<C> invoke() throws HTTPClientException {
        HTTPClient.HTTPResponse response = this.client.invoke();
        return new HTTPResponseWithJSONDecorator(response, this.jsonDecoratorConfig);
    }

    public static class HTTPResponseWithJSONDecorator<R>
    implements HTTPClient.HTTPResponse<R> {
        private HTTPClient.HTTPResponse<R> response;
        private byte[] normalizedJSON;
        private JSONDecoratorConfig jsonDecoratorConfig;

        public HTTPResponseWithJSONDecorator(HTTPClient.HTTPResponse<R> response, JSONDecoratorConfig jsonDecoratorConfig) {
            this.response = response;
            this.jsonDecoratorConfig = jsonDecoratorConfig;
        }

        private void normalizeJSON() throws HTTPClientException {
            if (this.normalizedJSON != null) {
                return;
            }
            String json = this.response.getBodyAsString().trim();
            try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                JsonValue jsonValue = reader.readValue();
                JsonDecoratorBuilder builder = JsonDecoratorFactoryImpl.getInstance().createBuilder('.');
                this.jsonDecoratorConfig.getCastConfigs().stream().forEach(c -> builder.cast(c.getPath(), c.getType(), c.getDefaultValue()));
                this.jsonDecoratorConfig.getFilterConfigs().stream().forEach(f -> builder.filterByType(f.getPath(), f.getType()));
                boolean isArray = jsonValue.getValueType() == JsonValue.ValueType.ARRAY;
                JsonValue decoratedJSONValue = builder.build(jsonValue);
                StringWriter sw = new StringWriter();
                this.writeJson(sw, isArray, decoratedJSONValue);
            }
            catch (Exception e) {
                throw new HTTPClientException("Can't normalize the JSON payload: " + e.getMessage(), e);
            }
        }

        private void writeJson(StringWriter sw, boolean isArray, JsonValue decoratedJSONValue) throws HTTPClientException {
            try (JsonWriter writer = Json.createWriter((Writer)sw);){
                JsonArray jsonStructure = isArray ? decoratedJSONValue.asJsonArray() : decoratedJSONValue.asJsonObject();
                writer.write((JsonStructure)jsonStructure);
                if (log.isTraceEnabled()) {
                    log.trace("Full HTTP response decorated JSON:\n" + sw);
                }
                this.normalizedJSON = sw.toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new HTTPClientException("Can't output normalized JSON: " + e.getMessage(), e);
            }
        }

        @Override
        public HTTPClient.Status getStatus() {
            return this.response.getStatus();
        }

        @Override
        public boolean isSuccess() {
            return this.response.isSuccess();
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.response.getHeaders();
        }

        @Override
        public String getBodyAsString() throws HTTPClientException {
            this.normalizeJSON();
            return new String(this.normalizedJSON, StandardCharsets.UTF_8);
        }

        @Override
        public InputStream getBodyAsStream() throws HTTPClientException {
            this.normalizeJSON();
            return new ByteArrayInputStream(this.normalizedJSON);
        }

        @Override
        public R getNestedResponse() {
            return this.response.getNestedResponse();
        }

        @Override
        public String getEncoding() {
            return this.response.getEncoding();
        }

        @Override
        public Optional<QueryConfiguration> nextPageQueryConfiguration() throws HTTPClientException {
            return this.response.nextPageQueryConfiguration();
        }

        @Override
        public int getLastPageCount() throws HTTPClientException {
            return this.response.getLastPageCount();
        }
    }
}

