/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.ParseException;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.attachments.UploadFileConfig;
import org.talend.components.common.httpclient.api.service.AttachmentService;
import org.talend.components.common.httpclient.impl.cxf.CXFHTTPResponseImpl;
import org.talend.components.common.httpclient.impl.cxf.CXFProcessedMultipartResponseImpl;

public class CXFAttachmentService
implements AttachmentService<Attachment, Response> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CXFAttachmentService.class);

    @Override
    public void saveAttachment(String resultFileName, InputStream stream) {
        File fileToWrite = new File(resultFileName);
        if (!fileToWrite.getParentFile().exists()) {
            fileToWrite.getParentFile().mkdirs();
        }
        if (fileToWrite.exists()) {
            log.warn("File {} already exists, attachment skipped", (Object)fileToWrite);
        } else {
            try (FileOutputStream fos = new FileOutputStream(fileToWrite);){
                int nb;
                byte[] buffer = new byte[1024];
                while ((nb = stream.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, nb);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Can't save the attachment " + resultFileName, e);
            }
        }
    }

    @Override
    public Attachment translateAttachmentFromConfig(final UploadFileConfig uploadFile) {
        File file = new File(uploadFile.getFilePath());
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalStateException("The file " + file.getPath() + " doesn't exist or is a directory");
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-ID", (Object)uploadFile.getName());
        StringBuilder contentDispositionString = new StringBuilder();
        contentDispositionString.append("form-data");
        contentDispositionString.append("; file=\"").append(uploadFile.getName()).append("\"");
        contentDispositionString.append("; name=\"").append(uploadFile.getName()).append("\"");
        contentDispositionString.append("; filename=\"").append(file.getName()).append("\"");
        try {
            contentDispositionString.append("; filename*=UTF-8''").append(URLEncoder.encode(file.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Got an UnsupportedEncodingException for UTF-8, shouldn't be here", (Throwable)e);
        }
        List<String> contentDispositionList = Collections.singletonList(contentDispositionString.toString());
        headers.put((Object)"Content-Disposition", contentDispositionList);
        ArrayList<String> contentTypeList = new ArrayList<String>();
        contentTypeList.add(uploadFile.getContentType());
        contentTypeList.add("charset=" + uploadFile.getEncoding());
        headers.put((Object)"Content-Type", contentTypeList);
        FileDataSource fileDataSource = new FileDataSource(file){

            public String getContentType() {
                return uploadFile.getContentType();
            }
        };
        DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
        return new Attachment(uploadFile.getName(), dataHandler, (MultivaluedMap)headers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HTTPClient.HTTPResponse<Response> processAttachmentsInResponse(HTTPClient.HTTPResponse<Response> response, QueryConfiguration config) throws HTTPClientException {
        if (response.getLastPageCount() == 0) {
            return response;
        }
        try (InputStream responseAsStream = response.getBodyAsStream();){
            MediaType mediaType = this.getNestedResponseMediaType(response);
            if (this.isMultipart(mediaType.getType())) {
                String mainBodyPart = this.parseMultipartAndSaveAttachments(mediaType.getType() + "/" + mediaType.getSubtype(), responseAsStream, config);
                CXFProcessedMultipartResponseImpl cXFProcessedMultipartResponseImpl = new CXFProcessedMultipartResponseImpl((CXFHTTPResponseImpl)response, mainBodyPart);
                return cXFProcessedMultipartResponseImpl;
            }
            String attachmentName = config.getAttachmentsConfiguration().isSpecifyAttachmentName() ? config.getAttachmentsConfiguration().getAttachmentName() : this.getAttachmentName(String.valueOf(response.getHeaders().get("Content-Disposition")), this.getResourceNameFromURL(config.getUrl()));
            String resultFileName = this.getResultAttachmentFilePath(config.getAttachmentsConfiguration().getAttachmentsDownloadDirectory(), attachmentName);
            this.saveAttachment(resultFileName, responseAsStream);
            HTTPClient.HTTPResponse<Response> hTTPResponse = response;
            return hTTPResponse;
        }
        catch (IOException e) {
            throw new HTTPClientException("Can not process response to save attachments", e);
        }
    }

    String getResultAttachmentFilePath(String directoryToSave, String attachmentName) {
        String baseFileName;
        if (!directoryToSave.endsWith("/") && !directoryToSave.endsWith("\\")) {
            directoryToSave = directoryToSave + File.separator;
        }
        String resultFileName = baseFileName = directoryToSave + attachmentName;
        int counter = 1;
        while (Files.exists(Paths.get(resultFileName, new String[0]), new LinkOption[0])) {
            StringBuilder resultFileNameBuilder = new StringBuilder();
            if (baseFileName.contains(".")) {
                resultFileNameBuilder.append(baseFileName.substring(0, baseFileName.lastIndexOf(46)));
                String extension = baseFileName.substring(baseFileName.lastIndexOf(46) + 1);
                resultFileNameBuilder.append("_").append(counter++).append(".").append(extension);
            } else {
                resultFileNameBuilder.append(baseFileName).append("_").append(counter++);
            }
            resultFileName = resultFileNameBuilder.toString();
        }
        log.debug("File with name {} already exists in the directory. Will be saved to {} instead.", (Object)attachmentName, (Object)resultFileName);
        return resultFileName;
    }

    private String getAttachmentName(HTTPClient.HTTPResponse<Response> response, QueryConfiguration config) {
        if (config.getAttachmentsConfiguration().isSpecifyAttachmentName()) {
            return config.getAttachmentsConfiguration().getAttachmentName();
        }
        return this.getAttachmentName(String.valueOf(response.getHeaders().get("Content-Disposition")), this.getResourceNameFromURL(config.getUrl()));
    }

    public String getAttachmentName(String contentDispositionHeader, String resourceName) {
        try {
            if (contentDispositionHeader == null) {
                return this.getDefaultAttachmentName(resourceName, 0);
            }
            ContentDisposition cd = new ContentDisposition(contentDispositionHeader);
            Optional<String> attachmentNameOptional = Optional.ofNullable(cd.getParameter("fileName"));
            return attachmentNameOptional.orElse(this.getDefaultAttachmentName(resourceName, 0));
        }
        catch (ParseException e) {
            log.debug("Can't parse an Content-Disposition header {} using the default file name", (Object)contentDispositionHeader, (Object)e);
            return this.getDefaultAttachmentName(resourceName, 0);
        }
    }

    protected String parseMultipartAndSaveAttachments(String mediaType, InputStream bodyStream, QueryConfiguration config) {
        try {
            MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(bodyStream, mediaType));
            return this.parseMultipartAndSaveAttachments(multipart, config);
        }
        catch (MessagingException | IOException e) {
            throw new RuntimeException("Multipart body parsing failed", e);
        }
    }

    private String parseMultipartAndSaveAttachments(MimeMultipart multipartBody, QueryConfiguration config) throws IOException {
        String notAttachmentBody = null;
        boolean isMainPartParsed = false;
        try {
            for (int i = 0; i < multipartBody.getCount(); ++i) {
                BodyPart bp = multipartBody.getBodyPart(i);
                try (InputStream bodyPartInputStream = bp.getInputStream();){
                    if (this.isMultipart(bp.getContentType())) {
                        this.parseMultipartAndSaveAttachments(bp.getContentType(), bodyPartInputStream, config);
                        continue;
                    }
                    if (this.isBodyPartAnAttachment(bp) || isMainPartParsed) {
                        String attachmentNameTemplate = config.getAttachmentsConfiguration().isSpecifyAttachmentName() ? config.getAttachmentsConfiguration().getAttachmentName() : this.getAttachmentNameForBodyPart(bp, this.getResourceNameFromURL(config.getUrl()), i);
                        String resultFileName = this.getResultAttachmentFilePath(config.getAttachmentsConfiguration().getAttachmentsDownloadDirectory(), attachmentNameTemplate);
                        this.saveAttachment(resultFileName, bodyPartInputStream);
                        continue;
                    }
                    notAttachmentBody = this.convertInputStreamToString(bodyPartInputStream);
                    isMainPartParsed = true;
                    continue;
                }
            }
        }
        catch (MessagingException e) {
            throw new IOException("Can't parse multipart message", e);
        }
        return notAttachmentBody;
    }

    private MediaType getNestedResponseMediaType(HTTPClient.HTTPResponse<Response> response) {
        return response.getNestedResponse().getMediaType();
    }

    private String getAttachmentNameForBodyPart(BodyPart bp, String resourceName, int index) throws MessagingException {
        String attachmentName = bp.getFileName();
        if (attachmentName == null && bp.getHeader("Content-Disposition") != null) {
            String header = bp.getHeader("Content-Disposition")[0];
            ContentDisposition cd = new ContentDisposition(header);
            attachmentName = cd.getParameter("name");
        }
        if (attachmentName == null) {
            attachmentName = this.getDefaultAttachmentName(resourceName, index);
        }
        return attachmentName;
    }

    private String getDefaultAttachmentName(String resourceName, int number) {
        String nameTemplate;
        if (!resourceName.endsWith("/")) {
            nameTemplate = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        } else {
            nameTemplate = resourceName.substring(0, resourceName.length() - 1);
            if (nameTemplate.contains("/")) {
                nameTemplate = nameTemplate.substring(nameTemplate.lastIndexOf("/") + 1);
            }
        }
        return nameTemplate + "_" + number;
    }

    private boolean isBodyPartAnAttachment(BodyPart bp) {
        try {
            return bp.getDisposition() != null && bp.getDisposition().equalsIgnoreCase("attachment");
        }
        catch (MessagingException e) {
            log.warn("Messaging exception", (Throwable)e);
            return false;
        }
    }

    private String convertInputStreamToString(InputStream is) throws IOException {
        int length;
        if (is == null) {
            is = new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        is.close();
        return result.toString(StandardCharsets.UTF_8.name());
    }

    private String getResourceNameFromURL(String url) {
        try {
            String path = new URL(url).getPath();
            if (path != null && path.contains("/")) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path.substring(path.lastIndexOf("/") + 1);
            }
            return path;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse the URL to get the resource name: " + url, e);
        }
    }
}

