/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.pagination;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.talend.components.common.httpclient.api.HTTPClient;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.KeyValuePair;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.pagination.OffsetLimitPagination;
import org.talend.components.common.httpclient.api.pagination.PaginationParametersLocation;
import org.talend.components.common.httpclient.pagination.PaginationStrategy;

public class OffsetLimitPaginationStrategy
implements PaginationStrategy {
    private QueryConfiguration queryConfiguration;
    private int lastCount = -1;

    public OffsetLimitPaginationStrategy(QueryConfiguration queryConfiguration) {
        this.queryConfiguration = queryConfiguration;
    }

    @Override
    public QueryConfiguration initiatePagination(QueryConfiguration queryConfiguration) {
        if (queryConfiguration.isInitPaginationDone()) {
            return queryConfiguration;
        }
        OffsetLimitPagination offsetLimitPagination = this.queryConfiguration.getOffsetLimitPagination();
        List<KeyValuePair> keyValuePairs = null;
        keyValuePairs = offsetLimitPagination.getLocation() == PaginationParametersLocation.HEADERS ? this.queryConfiguration.getHeaders() : this.queryConfiguration.getQueryParams();
        List<KeyValuePair> updatedKeyValuePairs = this.initKeyValuePairs(keyValuePairs, offsetLimitPagination);
        if (offsetLimitPagination.getLocation() == PaginationParametersLocation.HEADERS) {
            this.queryConfiguration.setHeaders(updatedKeyValuePairs);
        } else {
            this.queryConfiguration.setQueryParams(updatedKeyValuePairs);
        }
        this.queryConfiguration.setInitPaginationDone(true);
        return this.queryConfiguration;
    }

    @Override
    public Optional<QueryConfiguration> getNextPageConfiguration(HTTPClient.HTTPResponse response) throws HTTPClientException {
        int nbReceived = this.getLastCount(response);
        if (nbReceived <= 0) {
            return Optional.empty();
        }
        OffsetLimitPagination offsetLimitPagination = this.queryConfiguration.getOffsetLimitPagination();
        List<KeyValuePair> keyValuePairs = null;
        keyValuePairs = offsetLimitPagination.getLocation() == PaginationParametersLocation.HEADERS ? this.queryConfiguration.getHeaders() : this.queryConfiguration.getQueryParams();
        List<KeyValuePair> updatedKeyValuePairs = this.updateListKeyValuePair(keyValuePairs, offsetLimitPagination, nbReceived);
        if (offsetLimitPagination.getLocation() == PaginationParametersLocation.HEADERS) {
            this.queryConfiguration.setHeaders(updatedKeyValuePairs);
        } else {
            this.queryConfiguration.setQueryParams(updatedKeyValuePairs);
        }
        return Optional.ofNullable(this.queryConfiguration);
    }

    @Override
    public int getLastCount(HTTPClient.HTTPResponse response) throws HTTPClientException {
        if (this.lastCount < 0) {
            this.lastCount = this.computeNbReceivedElement(response);
        }
        return this.lastCount;
    }

    private List<KeyValuePair> initKeyValuePairs(List<KeyValuePair> kvps, OffsetLimitPagination offsetLimitPagination) {
        kvps.add(new KeyValuePair(offsetLimitPagination.getOffsetParamName(), offsetLimitPagination.getOffsetValue()));
        kvps.add(new KeyValuePair(offsetLimitPagination.getLimitParamName(), offsetLimitPagination.getLimitValue()));
        return kvps;
    }

    private List<KeyValuePair> updateListKeyValuePair(List<KeyValuePair> kvps, OffsetLimitPagination offsetLimitPagination, int nbReceivedElements) {
        String offsetParamName = offsetLimitPagination.getOffsetParamName();
        String limitParamName = offsetLimitPagination.getLimitParamName();
        Optional<KeyValuePair> existingOffset = kvps.stream().filter(h -> h.getKey().equals(offsetParamName)).findFirst();
        if (existingOffset.isPresent()) {
            existingOffset.get().setValue(this.nextOffset(existingOffset.get().getValue(), nbReceivedElements));
        } else {
            kvps.add(new KeyValuePair(offsetParamName, offsetLimitPagination.getOffsetValue()));
        }
        Optional<KeyValuePair> existingLimit = kvps.stream().filter(h -> h.getKey().equals(limitParamName)).findFirst();
        if (!existingLimit.isPresent()) {
            kvps.add(new KeyValuePair(limitParamName, offsetLimitPagination.getLimitValue()));
        }
        return kvps;
    }

    private String nextOffset(String previousOffset, int lastNbElements) {
        long previousOffsetLong = Long.parseLong(previousOffset);
        return String.valueOf(previousOffsetLong + (long)lastNbElements);
    }

    private int computeNbReceivedElement(HTTPClient.HTTPResponse response) throws HTTPClientException {
        String elementsPath = this.queryConfiguration.getOffsetLimitPagination().getElementsPath();
        while (elementsPath.startsWith(".")) {
            elementsPath = elementsPath.substring(1);
        }
        while (elementsPath.endsWith(".")) {
            elementsPath = elementsPath.substring(0, elementsPath.length() - 1);
        }
        String[] paths = (elementsPath = elementsPath.trim()).isEmpty() || ".".equals(elementsPath) ? new String[]{} : elementsPath.split("\\.");
        int nbElements = 0;
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(response.getBodyAsString()));
        if (paths.length == 0) {
            nbElements = jsonReader.readArray().size();
        } else {
            JsonObject current = jsonReader.readObject();
            for (int i = 0; i < paths.length; ++i) {
                boolean last;
                boolean bl = last = i == paths.length - 1;
                if (last) {
                    nbElements = current.getJsonArray(paths[i]).size();
                    continue;
                }
                current = current.getJsonObject(paths[i]);
            }
        }
        jsonReader.close();
        return nbElements;
    }
}

