/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.soap.sun;

import java.net.URL;

import sun.net.www.protocol.http.ntlm.NTLMAuthenticationCallback;

public class SunNtlmAuthenticationUpdater {

    private static SunNtlmAuthenticationUpdater instance;

    public static SunNtlmAuthenticationUpdater getInstance() {
        if (instance == null) {
            instance = new SunNtlmAuthenticationUpdater();
        }
        return instance;
    }

    private SunNtlmAuthenticationUpdater() {
    }

    public void resetNtlmAuthenticationCallback() {
        NTLMAuthenticationCallback.setNTLMAuthenticationCallback(createNtlmAuthenticationCallback());
    }

    private NTLMAuthenticationCallback createNtlmAuthenticationCallback() {
        return new NTLMAuthenticationCallback() {

            @Override
            public boolean isTrustedSite(URL arg0) {
                return false;
            }
        };
    }

}
