/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.StringUtils;

public class CommonUtils {
    private CommonUtils() {
    }

    public static String stripQuotes(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\"", "");
    }

    public static String formatHost(String host, String protocol) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return "";
        }
        if (host.startsWith("http")) {
            return host;
        }
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            return protocol + host;
        }
        return "https://" + host;
    }

    public static Region getDefaultRegion() {
        DefaultAwsRegionProviderChain build = DefaultAwsRegionProviderChain.builder().build();
        try {
            return build.getRegion();
        }
        catch (SdkClientException e) {
            return Region.US_EAST_1;
        }
    }
}

