/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws.s3;

import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.aws.CommonUtils;
import org.talend.components.aws.SettingHelper;
import org.talend.components.aws.s3.S3ClientProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public class HttpClientHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientHelper.class);
    private final SettingHelper settings;
    private String protocol = "https://";
    private ApacheHttpClient.Builder appachBuilder = ApacheHttpClient.builder();
    private S3ClientProvider.ProxyBuilder proxyBuilder = new S3ClientProvider.ProxyBuilder();
    private ClientOverrideConfiguration.Builder overrideBuilder = ClientOverrideConfiguration.builder();
    private boolean useProxy = false;

    public HttpClientHelper(SettingHelper settings) {
        this.settings = settings;
        this.init();
    }

    public void init() {
        if (this.settings.isConfigClient()) {
            block48: for (Map.Entry<String, String> clientConfig : this.settings.getClientConfiguration().entrySet()) {
                String clientParameter = CommonUtils.stripQuotes(clientConfig.getKey());
                String value = CommonUtils.stripQuotes(clientConfig.getValue());
                switch (clientParameter) {
                    case "ConnectionTimeout": 
                    case "CONNECTION_TIMEOUT": {
                        this.appachBuilder.connectionTimeout(Duration.ofMillis(Long.parseLong(value)));
                        continue block48;
                    }
                    case "MaxConnections": 
                    case "MAX_CONNECTIONS": {
                        this.appachBuilder.maxConnections(Integer.valueOf(Integer.parseInt(value)));
                        continue block48;
                    }
                    case "MaxErrorRetry": 
                    case "MAX_ERROR_RETRY": {
                        this.overrideBuilder.retryPolicy(RetryPolicy.builder().numRetries(Integer.valueOf(Integer.parseInt(value))).build());
                        continue block48;
                    }
                    case "RetryMode": 
                    case "RETRY_MODE": {
                        this.overrideBuilder.retryStrategy(RetryMode.valueOf((String)value.toUpperCase()));
                        continue block48;
                    }
                    case "Protocol": 
                    case "PROTOCOL": {
                        this.protocol = value.toLowerCase() + "://";
                        continue block48;
                    }
                    case "ProxyHost": 
                    case "PROXY_HOST": {
                        this.useProxy = true;
                        this.proxyBuilder.setProxyHost(value);
                        continue block48;
                    }
                    case "ProxyPort": 
                    case "PROXY_PORT": {
                        this.useProxy = true;
                        this.proxyBuilder.setProxyPort(value);
                        continue block48;
                    }
                    case "ProxyUsername": 
                    case "PROXY_USERNAME": {
                        this.useProxy = true;
                        this.proxyBuilder.setProxyUsername(value);
                        continue block48;
                    }
                    case "ProxyPassword": 
                    case "PROXY_PASSWORD": {
                        this.useProxy = true;
                        this.proxyBuilder.setProxyPassword(value);
                        continue block48;
                    }
                    case "ProxyDomain": 
                    case "PROXY_DOMAIN": {
                        this.proxyBuilder.setProxyDomain(value);
                        continue block48;
                    }
                    case "ProxyWorkstation": 
                    case "PROXY_WORKSTATION": {
                        this.proxyBuilder.setProxyWorkstation(value);
                        continue block48;
                    }
                    case "UserAgent": 
                    case "USER_AGENT": {
                        this.overrideBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)value);
                        continue block48;
                    }
                    case "SocketTimeout": 
                    case "SOCKET_TIMEOUT": {
                        this.appachBuilder.socketTimeout(Duration.ofMillis(Long.parseLong(value)));
                        continue block48;
                    }
                }
                log.warn("Unsupported Client configuration: {}", (Object)clientParameter);
            }
        }
        if (this.useProxy) {
            ProxyConfiguration proxyConfiguration = this.proxyBuilder.build();
            log.debug("Proxy Configuration {}", (Object)proxyConfiguration);
            this.appachBuilder.proxyConfiguration(proxyConfiguration);
        }
    }

    @Generated
    public SettingHelper getSettings() {
        return this.settings;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public ApacheHttpClient.Builder getAppachBuilder() {
        return this.appachBuilder;
    }

    @Generated
    public S3ClientProvider.ProxyBuilder getProxyBuilder() {
        return this.proxyBuilder;
    }

    @Generated
    public ClientOverrideConfiguration.Builder getOverrideBuilder() {
        return this.overrideBuilder;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setAppachBuilder(ApacheHttpClient.Builder appachBuilder) {
        this.appachBuilder = appachBuilder;
    }

    @Generated
    public void setProxyBuilder(S3ClientProvider.ProxyBuilder proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }

    @Generated
    public void setOverrideBuilder(ClientOverrideConfiguration.Builder overrideBuilder) {
        this.overrideBuilder = overrideBuilder;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientHelper)) {
            return false;
        }
        HttpClientHelper other = (HttpClientHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseProxy() != other.isUseProxy()) {
            return false;
        }
        SettingHelper this$settings = this.getSettings();
        SettingHelper other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        ApacheHttpClient.Builder this$appachBuilder = this.getAppachBuilder();
        ApacheHttpClient.Builder other$appachBuilder = other.getAppachBuilder();
        if (this$appachBuilder == null ? other$appachBuilder != null : !this$appachBuilder.equals(other$appachBuilder)) {
            return false;
        }
        S3ClientProvider.ProxyBuilder this$proxyBuilder = this.getProxyBuilder();
        S3ClientProvider.ProxyBuilder other$proxyBuilder = other.getProxyBuilder();
        if (this$proxyBuilder == null ? other$proxyBuilder != null : !((Object)this$proxyBuilder).equals(other$proxyBuilder)) {
            return false;
        }
        ClientOverrideConfiguration.Builder this$overrideBuilder = this.getOverrideBuilder();
        ClientOverrideConfiguration.Builder other$overrideBuilder = other.getOverrideBuilder();
        return !(this$overrideBuilder == null ? other$overrideBuilder != null : !this$overrideBuilder.equals(other$overrideBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpClientHelper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseProxy() ? 79 : 97);
        SettingHelper $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        ApacheHttpClient.Builder $appachBuilder = this.getAppachBuilder();
        result = result * 59 + ($appachBuilder == null ? 43 : $appachBuilder.hashCode());
        S3ClientProvider.ProxyBuilder $proxyBuilder = this.getProxyBuilder();
        result = result * 59 + ($proxyBuilder == null ? 43 : ((Object)$proxyBuilder).hashCode());
        ClientOverrideConfiguration.Builder $overrideBuilder = this.getOverrideBuilder();
        result = result * 59 + ($overrideBuilder == null ? 43 : $overrideBuilder.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpClientHelper(settings=" + this.getSettings() + ", protocol=" + this.getProtocol() + ", appachBuilder=" + this.getAppachBuilder() + ", proxyBuilder=" + this.getProxyBuilder() + ", overrideBuilder=" + this.getOverrideBuilder() + ", useProxy=" + this.isUseProxy() + ")";
    }
}

