/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws.s3;

import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.aws.CommonUtils;
import org.talend.components.aws.CredentialsProviderUtil;
import org.talend.components.aws.SettingHelper;
import org.talend.components.aws.s3.HttpClientHelper;
import org.talend.components.aws.s3.NettyClientHelper;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public class S3ClientProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ClientProvider.class);
    private final SettingHelper settings;

    public S3ClientProvider(SettingHelper settings) {
        this.settings = settings;
    }

    public S3Client createSyncS3Client(boolean crossRegionAccessEnabled) {
        S3ClientBuilder builder = S3Client.builder();
        HttpClientHelper httpClientHelper = new HttpClientHelper(this.settings);
        builder.httpClientBuilder((SdkHttpClient.Builder)httpClientHelper.getAppachBuilder());
        builder.overrideConfiguration((ClientOverrideConfiguration)httpClientHelper.getOverrideBuilder().build());
        if ("DEFAULT".equals(this.settings.getRegion())) {
            builder.crossRegionAccessEnabled(Boolean.valueOf(true));
            builder.region(Region.US_EAST_1);
        } else {
            builder.region(Region.of((String)this.settings.getRegion()));
            builder.crossRegionAccessEnabled(Boolean.valueOf(crossRegionAccessEnabled));
        }
        log.debug("Cross-region access: {}", (Object)crossRegionAccessEnabled);
        String regionEndpoint = this.settings.getRegionEndpoint();
        if (this.settings.isUseRegionEndpoint() && StringUtils.isNotBlank((CharSequence)regionEndpoint)) {
            URI uri = URI.create(CommonUtils.formatHost(regionEndpoint, httpClientHelper.getProtocol()));
            log.debug("Setting region endpoint: {}", (Object)uri);
            builder.endpointOverride(uri);
        }
        builder.credentialsProvider(this.getAwsCredentialsProvider());
        log.debug("Credentials provider set.");
        S3Client s3Client = (S3Client)builder.build();
        log.info("S3 SyncClient created successfully.");
        return s3Client;
    }

    public S3AsyncClient createAsyncS3Client() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        NettyClientHelper nettyClientHelper = new NettyClientHelper(this.settings);
        builder.httpClientBuilder((SdkAsyncHttpClient.Builder)nettyClientHelper.getNettyBuilder());
        builder.overrideConfiguration((ClientOverrideConfiguration)nettyClientHelper.getOverrideBuilder().build());
        if ("DEFAULT".equals(this.settings.getRegion())) {
            builder.crossRegionAccessEnabled(Boolean.valueOf(true));
            builder.region(Region.US_EAST_1);
        } else {
            builder.region(Region.of((String)this.settings.getRegion()));
        }
        String regionEndpoint = this.settings.getRegionEndpoint();
        if (this.settings.isUseRegionEndpoint() && StringUtils.isNotBlank((CharSequence)regionEndpoint)) {
            URI uri = URI.create(CommonUtils.formatHost(regionEndpoint, nettyClientHelper.getProtocol()));
            log.debug("Setting region endpoint: {}", (Object)uri);
            builder.endpointOverride(uri);
        }
        builder.credentialsProvider(this.getAwsCredentialsProvider());
        log.debug("Credentials provider set.");
        S3AsyncClient client = (S3AsyncClient)builder.build();
        log.info("S3AsyncClient created successfully.");
        return client;
    }

    public AwsCredentialsProvider getAwsCredentialsProvider() {
        log.info("Getting AWS credentials provider.");
        CredentialsProviderUtil credentialsProviderUtil = new CredentialsProviderUtil(this.settings);
        if (this.settings.isAssumeRole()) {
            log.debug("Using AssumeRole credentials provider.");
            return credentialsProviderUtil.getAssumeRoleCredentialsProvider();
        }
        log.debug("Using normal AWS credentials provider.");
        return credentialsProviderUtil.getNormalAwsCredentialsProvider();
    }

    public static class ProxyBuilder {
        private String proxyDomain;
        private String proxyHost;
        private String proxyPassword;
        private String proxyPort;
        private String proxyUsername;
        private String proxyWorkstation;

        public ProxyConfiguration build() {
            ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
            if (this.isEmpty(this.proxyHost)) {
                throw new IllegalArgumentException("ProxyHost cannot be null or empty.");
            }
            if (this.isEmpty(this.proxyPort)) {
                throw new IllegalArgumentException("ProxyPort cannot be null or empty.");
            }
            URI uri = URI.create(CommonUtils.formatHost(this.proxyHost, "http") + ":" + this.proxyPort);
            builder.endpoint(uri);
            Optional.ofNullable(this.proxyUsername).ifPresent(arg_0 -> ((ProxyConfiguration.Builder)builder).username(arg_0));
            Optional.ofNullable(this.proxyPassword).ifPresent(arg_0 -> ((ProxyConfiguration.Builder)builder).password(arg_0));
            Optional.ofNullable(this.proxyDomain).ifPresent(arg_0 -> ((ProxyConfiguration.Builder)builder).ntlmDomain(arg_0));
            Optional.ofNullable(this.proxyWorkstation).ifPresent(arg_0 -> ((ProxyConfiguration.Builder)builder).ntlmWorkstation(arg_0));
            return (ProxyConfiguration)builder.build();
        }

        private boolean isEmpty(String value) {
            return value == null || value.trim().isEmpty();
        }

        @Generated
        public ProxyBuilder() {
        }

        @Generated
        public String getProxyDomain() {
            return this.proxyDomain;
        }

        @Generated
        public String getProxyHost() {
            return this.proxyHost;
        }

        @Generated
        public String getProxyPassword() {
            return this.proxyPassword;
        }

        @Generated
        public String getProxyPort() {
            return this.proxyPort;
        }

        @Generated
        public String getProxyUsername() {
            return this.proxyUsername;
        }

        @Generated
        public String getProxyWorkstation() {
            return this.proxyWorkstation;
        }

        @Generated
        public void setProxyDomain(String proxyDomain) {
            this.proxyDomain = proxyDomain;
        }

        @Generated
        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        @Generated
        public void setProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
        }

        @Generated
        public void setProxyPort(String proxyPort) {
            this.proxyPort = proxyPort;
        }

        @Generated
        public void setProxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
        }

        @Generated
        public void setProxyWorkstation(String proxyWorkstation) {
            this.proxyWorkstation = proxyWorkstation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyBuilder)) {
                return false;
            }
            ProxyBuilder other = (ProxyBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$proxyDomain = this.getProxyDomain();
            String other$proxyDomain = other.getProxyDomain();
            if (this$proxyDomain == null ? other$proxyDomain != null : !this$proxyDomain.equals(other$proxyDomain)) {
                return false;
            }
            String this$proxyHost = this.getProxyHost();
            String other$proxyHost = other.getProxyHost();
            if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
                return false;
            }
            String this$proxyPassword = this.getProxyPassword();
            String other$proxyPassword = other.getProxyPassword();
            if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
                return false;
            }
            String this$proxyPort = this.getProxyPort();
            String other$proxyPort = other.getProxyPort();
            if (this$proxyPort == null ? other$proxyPort != null : !this$proxyPort.equals(other$proxyPort)) {
                return false;
            }
            String this$proxyUsername = this.getProxyUsername();
            String other$proxyUsername = other.getProxyUsername();
            if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
                return false;
            }
            String this$proxyWorkstation = this.getProxyWorkstation();
            String other$proxyWorkstation = other.getProxyWorkstation();
            return !(this$proxyWorkstation == null ? other$proxyWorkstation != null : !this$proxyWorkstation.equals(other$proxyWorkstation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProxyBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $proxyDomain = this.getProxyDomain();
            result = result * 59 + ($proxyDomain == null ? 43 : $proxyDomain.hashCode());
            String $proxyHost = this.getProxyHost();
            result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
            String $proxyPassword = this.getProxyPassword();
            result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
            String $proxyPort = this.getProxyPort();
            result = result * 59 + ($proxyPort == null ? 43 : $proxyPort.hashCode());
            String $proxyUsername = this.getProxyUsername();
            result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
            String $proxyWorkstation = this.getProxyWorkstation();
            result = result * 59 + ($proxyWorkstation == null ? 43 : $proxyWorkstation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "S3ClientProvider.ProxyBuilder(proxyDomain=" + this.getProxyDomain() + ", proxyHost=" + this.getProxyHost() + ", proxyPassword=" + this.getProxyPassword() + ", proxyPort=" + this.getProxyPort() + ", proxyUsername=" + this.getProxyUsername() + ", proxyWorkstation=" + this.getProxyWorkstation() + ")";
        }
    }
}

