/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.aws.s3;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.aws.SettingHelper;
import org.talend.components.aws.s3.S3ClientProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class S3Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Service.class);
    Map<SettingHelper, S3Client> syncPool = new HashMap<SettingHelper, S3Client>();
    Map<SettingHelper, S3AsyncClient> asyncPool = new HashMap<SettingHelper, S3AsyncClient>();

    public S3Client getSyncClient(SettingHelper settings, boolean crossRegionAccessEnabled) {
        S3Client s3Client;
        if (this.syncPool.get(settings) != null) {
            return this.syncPool.get(settings);
        }
        try {
            s3Client = new S3ClientProvider(settings).createSyncS3Client(crossRegionAccessEnabled);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("S3 client class: " + s3Client.getClass().getName());
        this.syncPool.put(settings, s3Client);
        return s3Client;
    }

    public S3AsyncClient getAsyncClient(SettingHelper settings) {
        S3AsyncClient s3Client;
        if (this.asyncPool.get(settings) != null) {
            return this.asyncPool.get(settings);
        }
        try {
            s3Client = new S3ClientProvider(settings).createAsyncS3Client();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.debug("S3 client class: " + s3Client.getClass().getName());
        this.asyncPool.put(settings, s3Client);
        return s3Client;
    }

    public boolean close(SettingHelper settings) {
        Optional.ofNullable(this.asyncPool.get(settings)).ifPresent(SdkAutoCloseable::close);
        Optional.ofNullable(this.syncPool.get(settings)).ifPresent(SdkAutoCloseable::close);
        return true;
    }
}

