/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.lib;

import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextWriter {
    File tmpFile;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextWriter.class);

    public ContextWriter(String seed) throws IOException {
        this.tmpFile = new File(FileUtils.getTempDirectoryPath() + "tmp_" + seed);
        LOGGER.info("Trying to create tmp file: " + this.tmpFile.getPath());
        try {
            FileUtils.touch((File)this.tmpFile);
        }
        catch (IOException e) {
            this.tmpFile = new File("tmp_" + seed);
            LOGGER.info("Trying to create tmp file: " + this.tmpFile.getPath());
            FileUtils.touch((File)this.tmpFile);
        }
    }

    public void write2File(List<String> paraList) {
        List contexts = paraList.stream().filter(e -> e.startsWith("--context_param") || e.startsWith("--context_type")).collect(Collectors.toList());
        try {
            FileUtils.writeLines((File)this.tmpFile, contexts);
            contexts.stream().forEach(e -> paraList.remove(e));
            paraList.add("--context_file " + this.getBase64FilePath());
        }
        catch (IOException e2) {
            LOGGER.error(e2.getLocalizedMessage());
            e2.printStackTrace();
        }
    }

    public String getTmpFilePath() {
        return this.tmpFile.getAbsolutePath();
    }

    public String getBase64FilePath() {
        return Base64.getEncoder().encodeToString(this.tmpFile.getAbsolutePath().getBytes());
    }

    public void clean() {
        if (this.tmpFile != null) {
            LOGGER.info("Deleting tmp file: " + this.tmpFile.getAbsolutePath());
            this.tmpFile.delete();
        }
    }
}

