/*
 * Decompiled with CFR 0.152.
 */
package org.talend.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.talend.proxy.ProxyCreds;

public class TalendProxyAuthenticator
extends Authenticator {
    private static TalendProxyAuthenticator instance;
    private Map<String, ProxyCreds> proxyCredsMap = new HashMap<String, ProxyCreds>();

    public static synchronized TalendProxyAuthenticator getInstance() {
        if (instance == null) {
            instance = new TalendProxyAuthenticator();
        }
        return instance;
    }

    private TalendProxyAuthenticator() {
    }

    public synchronized void addAuthForProxy(String host, String port, String userName, String pass) {
        this.proxyCredsMap.put(host + ":" + port, new ProxyCreds(userName, pass));
    }

    public synchronized ProxyCreds getCredsForProxyURI(String proxyURI) {
        return this.proxyCredsMap.get(proxyURI);
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        String requestURI = super.getRequestingHost() + ":" + super.getRequestingPort();
        if (this.proxyCredsMap.containsKey(requestURI)) {
            return new PasswordAuthentication(this.proxyCredsMap.get(requestURI).getUser(), this.proxyCredsMap.get(requestURI).getPass().toCharArray());
        }
        return super.getPasswordAuthentication();
    }
}

