/*
 * Decompiled with CFR 0.152.
 */
package org.talend.proxy;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.proxy.ProxyHolder;

public class TalendProxySelector
extends ProxySelector {
    private static TalendProxySelector instance;
    private static final Logger log;
    private ThreadLocal<ProxyHolder> threadLocalProxyHolder;
    private ProxyHolder globalProxyHolder = new ProxyHolder();

    public static synchronized TalendProxySelector getInstance() {
        if (instance == null) {
            instance = new TalendProxySelector();
        }
        return instance;
    }

    private TalendProxySelector() {
    }

    public synchronized void addProxySettings(Proxy proxy, boolean threadSpecific, String host, int port) {
        if (threadSpecific) {
            if (this.threadLocalProxyHolder == null) {
                this.threadLocalProxyHolder = new ThreadLocal();
            }
            if (this.threadLocalProxyHolder.get() == null) {
                ProxyHolder newProxyHolder = new ProxyHolder();
                this.threadLocalProxyHolder.set(newProxyHolder);
            }
            this.threadLocalProxyHolder.get().putNewHost(proxy, host, port);
        } else {
            this.globalProxyHolder.putNewHost(proxy, host, port);
        }
    }

    public synchronized Proxy getProxyForUriString(String uriString) {
        if (TalendProxySelector.proxyHolderContainsHost(this.globalProxyHolder, uriString)) {
            log.debug("All threads proxy " + this.globalProxyHolder.getProxyMap().get(uriString) + " is using to connect to URI " + uriString);
            return this.globalProxyHolder.getProxyMap().containsKey(uriString) ? this.globalProxyHolder.getProxyMap().get(uriString) : this.globalProxyHolder.getProxyMap().get(uriString.substring(0, uriString.lastIndexOf(":")));
        }
        if (this.threadLocalProxyHolder != null && TalendProxySelector.proxyHolderContainsHost(this.threadLocalProxyHolder.get(), uriString)) {
            log.debug("Proxy " + this.threadLocalProxyHolder.get().getProxyMap().get(uriString) + " is using to connect to URI " + uriString);
            return this.threadLocalProxyHolder.get().getProxyMap().containsKey(uriString) ? this.threadLocalProxyHolder.get().getProxyMap().get(uriString) : this.threadLocalProxyHolder.get().getProxyMap().get(uriString.substring(0, uriString.lastIndexOf(":")));
        }
        log.debug("No proxy is using to connect to URI " + uriString);
        return Proxy.NO_PROXY;
    }

    @Override
    public List<Proxy> select(URI uri) {
        String uriString = uri.getHost();
        if (uri.getPort() != -1) {
            uriString = uriString + ":" + uri.getPort();
        }
        log.debug("Network request hadling from Talend proxy selector. Thread " + Thread.currentThread().getName() + ". URI to connect: " + uriString);
        return Collections.singletonList(this.getProxyForUriString(uriString));
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (ioe != null) {
            log.warn("Connect failed when use Talend ProxySelector to the URI:" + uri.toString(), (Throwable)ioe);
        } else {
            log.warn("Connect failed when use Talend ProxySelector to the " + uri);
        }
    }

    private static boolean proxyHolderContainsHost(ProxyHolder holder, String uriString) {
        return holder != null && (holder.getProxyMap().containsKey(uriString) || uriString.contains(":") && holder.getProxyMap().containsKey(uriString.substring(0, uriString.indexOf(":"))));
    }

    static {
        log = LoggerFactory.getLogger(TalendProxySelector.class);
    }
}

