/*
 * Decompiled with CFR 0.152.
 */
package com.talend.qas;

import com.qas.web_2005_02.Address;
import com.qas.web_2005_02.AddressLineType;
import com.qas.web_2005_02.EngineEnumType;
import com.qas.web_2005_02.EngineType;
import com.qas.web_2005_02.Fault;
import com.qas.web_2005_02.ProWeb;
import com.qas.web_2005_02.QACanSearch;
import com.qas.web_2005_02.QAConfigType;
import com.qas.web_2005_02.QAGetAddress;
import com.qas.web_2005_02.QAPicklistType;
import com.qas.web_2005_02.QAPortType;
import com.qas.web_2005_02.QASearch;
import com.qas.web_2005_02.QASearchOk;
import com.qas.web_2005_02.QASearchResult;
import com.qas.web_2005_02.VerifyLevelType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class QASClient {
    private QAPortType qAPortType;
    private QASearch qaSearch;

    public QASClient(String url, String country) throws MalformedURLException {
        this.qAPortType = new ProWeb(new URL(url)).getQAPortType();
        this.qaSearch = new QASearch();
        this.qaSearch.setCountry(country);
        this.qaSearch.setLayout("( QAS Standard Layout )");
        EngineType engineType = new EngineType();
        engineType.setValue(EngineEnumType.VERIFICATION);
        this.qaSearch.setEngine(engineType);
        this.qaSearch.setQAConfig(new QAConfigType());
    }

    public QASearchResult search(String searchAddress) throws Fault {
        this.qaSearch.setSearch(searchAddress);
        QASearchResult results = this.qAPortType.doSearch(this.qaSearch);
        return results;
    }

    public Address finalAddress(String moniker) throws Fault {
        QAGetAddress getSearch = new QAGetAddress();
        getSearch.setMoniker(moniker);
        getSearch.setLayout("( QAS Standard Layout )");
        Address results = this.qAPortType.doGetAddress(getSearch);
        return results;
    }

    public QASearchOk canSearch() throws Fault {
        QACanSearch canSearch = new QACanSearch();
        canSearch.setCountry("FRX");
        EngineType engineType = new EngineType();
        engineType.setValue(EngineEnumType.SINGLELINE);
        canSearch.setEngine(engineType);
        canSearch.setLayout("( QAS Standard Layout )");
        QASearchOk results = this.qAPortType.doCanSearch(canSearch);
        return results;
    }

    public String[] getRightAddress(String searchAddress) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        QASearchResult searchResult = this.search(searchAddress);
        if (searchResult.getVerifyLevel().equals((Object)VerifyLevelType.VERIFIED) || searchResult.getVerifyLevel().equals((Object)VerifyLevelType.INTERACTION_REQUIRED)) {
            resultList.add(0, searchResult.getVerifyLevel().value());
            List<AddressLineType> addresses = searchResult.getQAAddress().getAddressLine();
            int i = 0;
            while (i < addresses.size()) {
                resultList.add(i + 1, addresses.get(i).getLine());
                ++i;
            }
        } else if (searchResult.getVerifyLevel().equals((Object)VerifyLevelType.STREET_PARTIAL) || searchResult.getVerifyLevel().equals((Object)VerifyLevelType.PREMISES_PARTIAL)) {
            resultList.add(0, searchResult.getVerifyLevel().value());
            QAPicklistType pickListType = searchResult.getQAPicklist();
            Address address = this.finalAddress(pickListType.getFullPicklistMoniker());
            List<AddressLineType> addresses = address.getQAAddress().getAddressLine();
            int i = 0;
            while (i < addresses.size()) {
                resultList.add(i + 1, addresses.get(i).getLine());
                ++i;
            }
        } else {
            resultList.add(0, searchResult.getVerifyLevel().value());
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public static void main(String[] args) {
        try {
            QASClient qasClient = new QASClient("http://10.42.10.41:1050/proweb.wsdl", "FRX");
            long begin = System.currentTimeMillis();
            int i = 0;
            while (i < 30) {
                String[] results3;
                String[] results2;
                String[] results;
                System.out.println(i);
                String[] stringArray = results = qasClient.getRightAddress("9 Rue pag\u00e8s, 92150 Suresnes");
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    System.out.println(str);
                    ++n2;
                }
                String[] stringArray2 = results2 = qasClient.getRightAddress("15 rue verdun, 92150 Suresnes");
                int n3 = results2.length;
                n = 0;
                while (n < n3) {
                    String str = stringArray2[n];
                    System.out.println(str);
                    ++n;
                }
                String[] stringArray3 = results3 = qasClient.getRightAddress("Rue pag\u00e8s , 92150, France");
                int n4 = results3.length;
                n3 = 0;
                while (n3 < n4) {
                    String str = stringArray3[n3];
                    System.out.println(str);
                    ++n3;
                }
                ++i;
            }
            System.out.println(System.currentTimeMillis() - begin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

