/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.parsing.core;

import com.github.jcrfsuite.CrfTagger;
import com.github.jcrfsuite.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.talend.dataquality.parsing.core.FeaturesGenerator;

public abstract class CrfParser<T> {
    protected CrfTagger parserModel;
    protected FeaturesGenerator featuresGenerator;

    public T parse(String rawString) {
        StringTokenizer st = new StringTokenizer(rawString);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        List tagProbPairs = this.parserModel.tag(this.featuresGenerator.getFeatureSequenceFromTokens(tokens));
        List<String> tags = tagProbPairs.stream().map(Pair::getFirst).collect(Collectors.toList());
        List<Double> probs = tagProbPairs.stream().map(Pair::getSecond).collect(Collectors.toList());
        return this.getParsedResult(tokens, tags, probs);
    }

    public abstract T getParsedResult(List<String> var1, List<String> var2, List<Double> var3);

    public CrfTagger getParserModel() {
        return this.parserModel;
    }

    public FeaturesGenerator getFeaturesGenerator() {
        return this.featuresGenerator;
    }
}

