/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.talend.dataquality.semantic.model.CategoryPrivacyLevel;
import org.talend.dataquality.semantic.model.CategoryState;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQRegEx;
import org.talend.dataquality.semantic.model.ValidationMode;

public class DQCategory
implements Serializable {
    private static final long serialVersionUID = 4593691452129397269L;
    private String id;
    private String name;
    private String label;
    private String description;
    private CategoryType type;
    private CategoryPrivacyLevel privacyLevel;
    private String version;
    private String creator;
    private String creatorName;
    private Date createdAt;
    private DQRegEx regEx;
    private Date modifiedAt;
    private String lastModifier;
    private String lastModifierName;
    private Boolean completeness;
    private Date publishedAt;
    private String lastPublisher;
    private String lastPublisherName;
    private ValidationMode validationMode;
    private CategoryState state;
    private List<DQCategory> children;
    private List<DQCategory> parents;
    @JsonIgnore
    private Boolean modified = Boolean.FALSE;
    @JsonIgnore
    private Boolean deleted = Boolean.FALSE;

    public DQCategory(String id) {
        this.id = id;
    }

    public DQCategory() {
    }

    public static DQCategoryBuilder newBuilder() {
        return new DQCategoryBuilder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryType getType() {
        return this.type;
    }

    public void setType(CategoryType type) {
        this.type = type;
    }

    public CategoryPrivacyLevel getPrivacyLevel() {
        return this.privacyLevel;
    }

    public void setPrivacyLevel(CategoryPrivacyLevel privacyLevel) {
        this.privacyLevel = privacyLevel;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public DQRegEx getRegEx() {
        return this.regEx;
    }

    public void setRegEx(DQRegEx regEx) {
        this.regEx = regEx;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(Boolean completeness) {
        this.completeness = completeness;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public String getLastModifierName() {
        return this.lastModifierName;
    }

    public void setLastModifierName(String lastModifierName) {
        this.lastModifierName = lastModifierName;
    }

    public Date getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
    }

    public String getLastPublisher() {
        return this.lastPublisher;
    }

    public void setLastPublisher(String lastPublisher) {
        this.lastPublisher = lastPublisher;
    }

    public String getLastPublisherName() {
        return this.lastPublisherName;
    }

    public void setLastPublisherName(String lastPublisherName) {
        this.lastPublisherName = lastPublisherName;
    }

    public CategoryState getState() {
        return this.state;
    }

    public void setState(CategoryState state) {
        this.state = state;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public List<DQCategory> getChildren() {
        return this.children;
    }

    public void setChildren(List<DQCategory> children) {
        this.children = children;
    }

    public List<DQCategory> getParents() {
        return this.parents;
    }

    public void setParents(List<DQCategory> parents) {
        this.parents = parents;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public Boolean getModified() {
        return this.modified;
    }

    public void setModified(Boolean modified) {
        this.modified = modified;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return String.format("Category [ID=%s  Type=%s  Name=%-20s  Label=%-20s  Completeness=%s  Modified=%-5s  Creator=%s Last Modifier=%s State=%-20s Last published=%s]", new Object[]{this.id, this.type, this.name, this.label, this.completeness, this.modified, this.creator, this.lastModifier, this.state, this.publishedAt});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DQCategory that = (DQCategory)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.label, that.label) && Objects.equals(this.description, that.description) && this.type == that.type && this.privacyLevel == that.privacyLevel && Objects.equals(this.version, that.version) && Objects.equals(this.regEx, that.regEx) && Objects.equals(this.completeness, that.completeness) && this.validationMode == that.validationMode && this.state == that.state && Objects.equals(this.children, that.children) && Objects.equals(this.parents, that.parents) && Objects.equals(this.modified, that.modified) && Objects.equals(this.deleted, that.deleted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.label, this.description, this.type, this.privacyLevel, this.version, this.regEx, this.completeness, this.validationMode, this.state, this.children, this.parents, this.modified, this.deleted});
    }

    public static final class DQCategoryBuilder {
        private String id;
        private String name;
        private String label;
        private String description;
        private CategoryType type;
        private CategoryPrivacyLevel privacyLevel;
        private String version;
        private String creator;
        private String creatorName;
        private Date createdAt;
        private DQRegEx regEx;
        private Date modifiedAt;
        private String lastModifier;
        private String lastModifierName;
        private Boolean completeness;
        private Date publishedAt;
        private String lastPublisher;
        private String lastPublisherName;
        private ValidationMode validationMode;
        private CategoryState state;
        private List<DQCategory> children;
        private List<DQCategory> parents;
        private Boolean modified = Boolean.FALSE;
        private Boolean deleted = Boolean.FALSE;

        private DQCategoryBuilder() {
        }

        public DQCategoryBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DQCategoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DQCategoryBuilder label(String label) {
            this.label = label;
            return this;
        }

        public DQCategoryBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DQCategoryBuilder type(CategoryType type) {
            this.type = type;
            return this;
        }

        public DQCategoryBuilder privacyLevel(CategoryPrivacyLevel privacyLevel) {
            this.privacyLevel = privacyLevel;
            return this;
        }

        public DQCategoryBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DQCategoryBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public DQCategoryBuilder creatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        public DQCategoryBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public DQCategoryBuilder regEx(DQRegEx regEx) {
            this.regEx = regEx;
            return this;
        }

        public DQCategoryBuilder modifiedAt(Date modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public DQCategoryBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public DQCategoryBuilder lastModifierName(String lastModifierName) {
            this.lastModifierName = lastModifierName;
            return this;
        }

        public DQCategoryBuilder completeness(Boolean completeness) {
            this.completeness = completeness;
            return this;
        }

        public DQCategoryBuilder publishedAt(Date publishedAt) {
            this.publishedAt = publishedAt;
            return this;
        }

        public DQCategoryBuilder lastPublisher(String lastPublisher) {
            this.lastPublisher = lastPublisher;
            return this;
        }

        public DQCategoryBuilder lastPublisherName(String lastPublisherName) {
            this.lastPublisherName = lastPublisherName;
            return this;
        }

        public DQCategoryBuilder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        public DQCategoryBuilder state(CategoryState state) {
            this.state = state;
            return this;
        }

        public DQCategoryBuilder children(List<DQCategory> children) {
            this.children = children;
            return this;
        }

        public DQCategoryBuilder parents(List<DQCategory> parents) {
            this.parents = parents;
            return this;
        }

        public DQCategoryBuilder modified(Boolean modified) {
            this.modified = modified;
            return this;
        }

        public DQCategoryBuilder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public DQCategory build() {
            DQCategory dQCategory = new DQCategory();
            dQCategory.setId(this.id);
            dQCategory.setName(this.name);
            dQCategory.setLabel(this.label);
            dQCategory.setDescription(this.description);
            dQCategory.setType(this.type);
            dQCategory.setPrivacyLevel(this.privacyLevel);
            dQCategory.setVersion(this.version);
            dQCategory.setCreator(this.creator);
            dQCategory.setCreatorName(this.creatorName);
            dQCategory.setCreatedAt(this.createdAt);
            dQCategory.setRegEx(this.regEx);
            dQCategory.setModifiedAt(this.modifiedAt);
            dQCategory.setLastModifier(this.lastModifier);
            dQCategory.setLastModifierName(this.lastModifierName);
            dQCategory.setCompleteness(this.completeness);
            dQCategory.setPublishedAt(this.publishedAt);
            dQCategory.setLastPublisher(this.lastPublisher);
            dQCategory.setLastPublisherName(this.lastPublisherName);
            dQCategory.setValidationMode(this.validationMode);
            dQCategory.setState(this.state);
            dQCategory.setChildren(this.children);
            dQCategory.setParents(this.parents);
            dQCategory.setModified(this.modified);
            dQCategory.setDeleted(this.deleted);
            return dQCategory;
        }
    }
}

