/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.talend.dataquality.semantic.model.CategoryState;
import org.talend.dataquality.semantic.model.DQCategory;

public class DQDocument
implements Serializable {
    private static final long serialVersionUID = 4167438961487139761L;
    private String id;
    private Set<String> values;
    private DQCategory category;
    private String creator;
    private Date createdAt;
    private Date modifiedAt;
    private String lastModifier;
    private CategoryState state;

    public static DQDocumentBuilder newBuilder() {
        return new DQDocumentBuilder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void setValues(Set<String> values) {
        this.values = values;
    }

    public DQCategory getCategory() {
        return this.category;
    }

    public void setCategory(DQCategory category) {
        this.category = category;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public CategoryState getState() {
        return this.state;
    }

    public void setState(CategoryState state) {
        this.state = state;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        String categoryId = this.category != null ? ", categoryId=" + this.category.getId() : "";
        return "DQDocument{id='" + this.id + '\'' + ", values=" + this.values + categoryId + ", creator='" + this.creator + '\'' + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", lastModifier='" + this.lastModifier + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DQDocument that = (DQDocument)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.values, that.values) && Objects.equals(this.category, that.category) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.values, this.category, this.state});
    }

    public static final class DQDocumentBuilder {
        private String id;
        private Set<String> values;
        private DQCategory category;
        private String creator;
        private Date createdAt;
        private Date modifiedAt;
        private String lastModifier;
        private CategoryState state;

        private DQDocumentBuilder() {
        }

        public DQDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DQDocumentBuilder values(Set<String> values) {
            this.values = values;
            return this;
        }

        public DQDocumentBuilder category(DQCategory category) {
            this.category = category;
            return this;
        }

        public DQDocumentBuilder categoryId(String categoryId) {
            this.category = new DQCategory(categoryId);
            return this;
        }

        public DQDocumentBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public DQDocumentBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public DQDocumentBuilder modifiedAt(Date modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public DQDocumentBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public DQDocumentBuilder state(CategoryState state) {
            this.state = state;
            return this;
        }

        public DQDocument build() {
            DQDocument dQDocument = new DQDocument();
            dQDocument.setId(this.id);
            dQDocument.setValues(this.values);
            dQDocument.setCategory(this.category);
            dQDocument.setCreator(this.creator);
            dQDocument.setCreatedAt(this.createdAt);
            dQDocument.setModifiedAt(this.modifiedAt);
            dQDocument.setLastModifier(this.lastModifier);
            dQDocument.setState(this.state);
            return dQDocument;
        }
    }
}

