/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.model.DQCategory;

public class CategoryMetadataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryMetadataUtils.class);

    private CategoryMetadataUtils() {
    }

    public static Map<String, DQCategory> loadMetadataFromIndex(Directory directory) {
        HashMap<String, DQCategory> sharedMetadata = new HashMap<String, DQCategory>();
        HashMap<String, Set<String>> categoryToParents = new HashMap<String, Set<String>>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (liveDocs != null && !liveDocs.get(i)) continue;
                Document doc = reader.document(i);
                DQCategory dqCat = DictionaryUtils.categoryFromDocument(doc);
                sharedMetadata.put(dqCat.getId(), dqCat);
                if (CollectionUtils.isEmpty((Collection)dqCat.getChildren())) continue;
                CategoryMetadataUtils.fillCategoryToParents(categoryToParents, dqCat);
            }
            for (Map.Entry entry : categoryToParents.entrySet()) {
                if (sharedMetadata.get(entry.getKey()) == null) continue;
                ArrayList<DQCategory> parentCategoryList = new ArrayList<DQCategory>();
                for (String childCategoryId : (Set)entry.getValue()) {
                    parentCategoryList.add(new DQCategory(childCategoryId));
                }
                sharedMetadata.get(entry.getKey()).setParents(parentCategoryList);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return sharedMetadata;
    }

    private static void fillCategoryToParents(Map<String, Set<String>> categoryToParents, DQCategory dqCat) {
        for (DQCategory cat : dqCat.getChildren()) {
            if (categoryToParents.get(cat.getId()) == null) {
                categoryToParents.put(cat.getId(), new HashSet());
            }
            categoryToParents.get(cat.getId()).add(dqCat.getId());
        }
    }
}

