/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.multitenant.context.TenancyContextHolder;
import org.talend.daikon.multitenant.core.Tenant;
import org.talend.dataquality.semantic.api.CategoryMetadataUtils;
import org.talend.dataquality.semantic.api.CustomDictionaryHolder;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.LocalDictionaryCache;
import org.talend.dataquality.semantic.classifier.custom.UDCategorySerDeser;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;

public class CategoryRegistryManager {
    public static final String METADATA_SUBFOLDER_NAME = "metadata";
    public static final String DICTIONARY_SUBFOLDER_NAME = "dictionary";
    public static final String KEYWORD_SUBFOLDER_NAME = "keyword";
    public static final String REGEX_SUBFOLDER_NAME = "regex";
    public static final String REGEX_CATEGORIZER_FILE_NAME = "categorizer.json";
    public static final String SHARED_FOLDER_NAME = "shared";
    public static final String PRODUCTION_FOLDER_NAME = "prod";
    public static final String REPUBLISH_FOLDER_NAME = "republish";
    public static final String DEFAULT_TENANT_ID = "t_default";
    public static final String DEFAULT_RE_PATH = "/regex/categorizer.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryRegistryManager.class);
    private static final Map<String, CustomDictionaryHolder> customDictionaryHolderMap = new HashMap<String, CustomDictionaryHolder>();
    private static final String DEFAULT_LOCAL_REGISTRY_PATH = System.getProperty("user.home") + "/.talend/dataquality/semantic";
    private static final Object indexExtractionLock = new Object();
    private static CategoryRegistryManager instance;
    private static boolean usingLocalCategoryRegistry;
    private static String localRegistryPath;
    private Map<String, DQCategory> sharedMetadata = new LinkedHashMap<String, DQCategory>();
    private UserDefinedClassifier sharedRegexClassifier;
    private Directory sharedDataDictDirectory;
    private Directory sharedKeywordDirectory;
    private ObjectMapper mapper = new ObjectMapper();

    private CategoryRegistryManager() {
        try {
            if (usingLocalCategoryRegistry) {
                this.loadRegisteredCategories();
            } else {
                this.loadInitialCategories();
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static CategoryRegistryManager getInstance() {
        if (instance == null) {
            instance = new CategoryRegistryManager();
        }
        return instance;
    }

    public static void reset() {
        CategoryRegistryManager.setUsingLocalCategoryRegistry(false);
        localRegistryPath = DEFAULT_LOCAL_REGISTRY_PATH;
        instance = null;
    }

    static boolean isUsingLocalCategoryRegistry() {
        return usingLocalCategoryRegistry;
    }

    public static void setUsingLocalCategoryRegistry(boolean b) {
        usingLocalCategoryRegistry = b;
    }

    public static String getLocalRegistryPath() {
        return localRegistryPath;
    }

    public static void setLocalRegistryPath(String folder) {
        if (folder != null && folder.trim().length() > 0) {
            localRegistryPath = folder;
            usingLocalCategoryRegistry = true;
            instance = new CategoryRegistryManager();
        } else {
            LOGGER.warn("Cannot set an empty path as local registry location. Use default one: " + localRegistryPath);
        }
    }

    public LocalDictionaryCache getDictionaryCache() {
        return this.getCustomDictionaryHolder().getDictionaryCache();
    }

    public void reloadCategoriesFromRegistry() {
        LOGGER.info("Reload categories from local registry.");
        this.getCustomDictionaryHolder().reloadCategoryMetadata();
    }

    private void loadRegisteredCategories() throws IOException, URISyntaxException {
        LOGGER.info("Loading categories from local registry.");
        File categorySubFolder = new File(localRegistryPath + File.separator + SHARED_FOLDER_NAME + File.separator + PRODUCTION_FOLDER_NAME + File.separator + METADATA_SUBFOLDER_NAME);
        this.loadBaseIndex(categorySubFolder, METADATA_SUBFOLDER_NAME);
        if (categorySubFolder.exists()) {
            this.sharedMetadata = CategoryMetadataUtils.loadMetadataFromIndex((Directory)FSDirectory.open((File)categorySubFolder));
        }
        File dictionarySubFolder = new File(localRegistryPath + File.separator + SHARED_FOLDER_NAME + File.separator + PRODUCTION_FOLDER_NAME + File.separator + DICTIONARY_SUBFOLDER_NAME);
        this.loadBaseIndex(dictionarySubFolder, DICTIONARY_SUBFOLDER_NAME);
        File keywordSubFolder = new File(localRegistryPath + File.separator + SHARED_FOLDER_NAME + File.separator + PRODUCTION_FOLDER_NAME + File.separator + KEYWORD_SUBFOLDER_NAME);
        this.loadBaseIndex(keywordSubFolder, KEYWORD_SUBFOLDER_NAME);
        File regexRegistryFile = new File(localRegistryPath + File.separator + SHARED_FOLDER_NAME + File.separator + PRODUCTION_FOLDER_NAME + File.separator + REGEX_SUBFOLDER_NAME + File.separator + REGEX_CATEGORIZER_FILE_NAME);
        this.loadBaseRegex(regexRegistryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBaseRegex(File regexRegistryFile) throws IOException {
        if (!regexRegistryFile.exists()) {
            InputStream is = this.getClass().getResourceAsStream(DEFAULT_RE_PATH);
            StringBuilder sb = new StringBuilder();
            for (String line : IOUtils.readLines((InputStream)is)) {
                sb.append(line);
            }
            regexRegistryFile.getParentFile().mkdirs();
            try (FileOutputStream fos = null;){
                JsonNode objNode = this.mapper.readTree(sb.toString());
                JsonNode array = objNode.get("classifiers");
                fos = new FileOutputStream(regexRegistryFile);
                IOUtils.write((String)array.toString(), (OutputStream)fos);
            }
        }
    }

    private void loadInitialCategories() throws IOException, URISyntaxException {
        this.sharedMetadata = CategoryMetadataUtils.loadMetadataFromIndex(ClassPathDirectory.open(this.getMetadataURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBaseIndex(File destSubFolder, String sourceSubFolder) throws IOException, URISyntaxException {
        Object object = indexExtractionLock;
        synchronized (object) {
            if (!destSubFolder.exists()) {
                boolean baseIndexExtracted = false;
                ArrayList<URL> potentialResources = Collections.list(this.getClass().getClassLoader().getResources(sourceSubFolder));
                for (URL url : potentialResources) {
                    URI uri = url.toURI();
                    LOGGER.info("trying to load base index from " + uri.toString());
                    try {
                        Directory srcDir = ClassPathDirectory.open(uri);
                        Throwable throwable = null;
                        try {
                            if (!usingLocalCategoryRegistry || destSubFolder.exists()) continue;
                            DictionaryUtils.rewriteIndex(srcDir, destSubFolder);
                            LOGGER.info("base index loaded from " + uri.toString());
                            baseIndexExtracted = true;
                            break;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (srcDir == null) continue;
                            if (throwable != null) {
                                try {
                                    srcDir.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            srcDir.close();
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("could not load base index from " + uri.toString());
                    }
                }
                if (usingLocalCategoryRegistry && !destSubFolder.exists() && !baseIndexExtracted) {
                    StringBuilder error = new StringBuilder(100);
                    error.append("Could not load base index out of theses locations : [\n");
                    potentialResources.forEach(pr -> error.append('\t').append(pr.toString()).append('\n'));
                    error.append(']');
                    throw new IllegalArgumentException(error.toString());
                }
            }
        }
    }

    public Collection<DQCategory> listCategories() {
        return this.getCustomDictionaryHolder().listCategories();
    }

    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        return this.getCustomDictionaryHolder().listCategories(includeOpenCategories);
    }

    public List<DQCategory> listCategories(CategoryType type) {
        return this.getCustomDictionaryHolder().listCategories(type);
    }

    public Map<String, DQCategory> getSharedCategoryMetadata() {
        return this.sharedMetadata;
    }

    public Directory getSharedDataDictDirectory() {
        if (this.sharedDataDictDirectory == null) {
            try {
                this.sharedDataDictDirectory = ClassPathDirectory.open(this.getDictionaryURI());
            }
            catch (URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.sharedDataDictDirectory;
    }

    public Directory getSharedKeywordDirectory() {
        if (this.sharedKeywordDirectory == null) {
            try {
                this.sharedKeywordDirectory = ClassPathDirectory.open(this.getKeywordURI());
            }
            catch (URISyntaxException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.sharedKeywordDirectory;
    }

    public Map<String, DQCategory> getCategoryMetadataMap() {
        return this.getCustomDictionaryHolder().getMetadata();
    }

    public DQCategory getCategoryMetadataById(String catId) {
        return this.getCustomDictionaryHolder().getCategoryMetadataById(catId);
    }

    public DQCategory getCategoryMetadataByName(String catName) {
        return this.getCustomDictionaryHolder().getCategoryMetadataByName(catName);
    }

    public UserDefinedClassifier getRegexClassifier() {
        block7: {
            if (!usingLocalCategoryRegistry) {
                try {
                    return UDCategorySerDeser.getRegexClassifier();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    break block7;
                }
            }
            if (this.sharedRegexClassifier == null) {
                File regexRegistryFile = new File(localRegistryPath + File.separator + SHARED_FOLDER_NAME + File.separator + PRODUCTION_FOLDER_NAME + File.separator + REGEX_SUBFOLDER_NAME + File.separator + REGEX_CATEGORIZER_FILE_NAME);
                try {
                    if (!regexRegistryFile.exists()) {
                        this.loadBaseRegex(regexRegistryFile);
                    }
                    this.sharedRegexClassifier = UDCategorySerDeser.readJsonFile(regexRegistryFile.toURI());
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.sharedRegexClassifier;
    }

    private URI getMetadataURI() throws URISyntaxException {
        if (usingLocalCategoryRegistry) {
            return Paths.get(localRegistryPath, SHARED_FOLDER_NAME, PRODUCTION_FOLDER_NAME, METADATA_SUBFOLDER_NAME).toUri();
        }
        return this.getClass().getResource("/metadata/").toURI();
    }

    public URI getDictionaryURI() throws URISyntaxException {
        if (usingLocalCategoryRegistry) {
            return Paths.get(localRegistryPath, SHARED_FOLDER_NAME, PRODUCTION_FOLDER_NAME, DICTIONARY_SUBFOLDER_NAME).toUri();
        }
        return this.getClass().getResource("/dictionary/").toURI();
    }

    public URI getKeywordURI() throws URISyntaxException {
        if (usingLocalCategoryRegistry) {
            return Paths.get(localRegistryPath, SHARED_FOLDER_NAME, PRODUCTION_FOLDER_NAME, KEYWORD_SUBFOLDER_NAME).toUri();
        }
        return this.getClass().getResource("/keyword/").toURI();
    }

    public URI getRegexURI() throws URISyntaxException {
        if (usingLocalCategoryRegistry) {
            return Paths.get(localRegistryPath, SHARED_FOLDER_NAME, PRODUCTION_FOLDER_NAME, REGEX_SUBFOLDER_NAME, REGEX_CATEGORIZER_FILE_NAME).toUri();
        }
        return this.getClass().getResource(DEFAULT_RE_PATH).toURI();
    }

    public CustomDictionaryHolder getCustomDictionaryHolder() {
        Object identity;
        Optional tenant = TenancyContextHolder.getContext().getOptionalTenant();
        if (tenant.isPresent() && (identity = ((Tenant)tenant.get()).getIdentity()) != null && !"null".equals(String.valueOf(identity))) {
            return this.getCustomDictionaryHolder(String.valueOf(identity));
        }
        return this.getCustomDictionaryHolder(DEFAULT_TENANT_ID);
    }

    public synchronized CustomDictionaryHolder getCustomDictionaryHolder(String tenantID) {
        CustomDictionaryHolder cdh = customDictionaryHolderMap.get(tenantID);
        if (cdh == null) {
            LOGGER.info("Instantiate CustomDictionaryHolder for [" + tenantID + "]");
            cdh = new CustomDictionaryHolder(tenantID);
            customDictionaryHolderMap.put(tenantID, cdh);
        }
        return cdh;
    }

    public String findMostSimilarValue(String input, String categoryName, double similarity) {
        LuceneIndex index = this.getLuceneIndex(categoryName);
        if (index == null) {
            return input;
        }
        return index.findMostSimilarFieldInCategory(input, categoryName, similarity);
    }

    LuceneIndex getLuceneIndex(String categoryName) {
        DQCategory dqCategory = this.getCategoryMetadataByName(categoryName);
        if (dqCategory != null) {
            Directory dataDictDirectory = null;
            dataDictDirectory = dqCategory.getModified() != false ? this.getCustomDictionaryHolder().getDataDictDirectory() : this.getSharedDataDictDirectory();
            return new LuceneIndex(dataDictDirectory, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY);
        }
        return null;
    }

    static {
        usingLocalCategoryRegistry = false;
        localRegistryPath = DEFAULT_LOCAL_REGISTRY_PATH;
    }
}

