/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.LocalDictionaryCache;
import org.talend.dataquality.semantic.api.internal.CustomDocumentIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomMetadataIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomRegexClassifierAccess;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class CustomDictionaryHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDictionaryHolder.class);
    private static final String INITIALIZE_ACCESS = "Initialize %s %s access for [%s]";
    private static final String CUSTOM = "custom";
    private static final String TALEND = "Talend";
    private static final String SYSTEM = "System";
    private Map<String, DQCategory> metadata;
    private Directory dataDictDirectory;
    private UserDefinedClassifier regexClassifier;
    private CustomMetadataIndexAccess customMetadataIndexAccess;
    private CustomDocumentIndexAccess customDocumentIndexAccess;
    private CustomRegexClassifierAccess customRegexClassifierAccess;
    private CustomMetadataIndexAccess customRepublishMetadataIndexAccess;
    private CustomDocumentIndexAccess customRepublishDataDictIndexAccess;
    private CustomRegexClassifierAccess customRepublishRegexClassifierAccess;
    private LocalDictionaryCache localDictionaryCache;
    private String tenantID;

    public CustomDictionaryHolder(String tenantID) {
        this.tenantID = tenantID;
        if (CategoryRegistryManager.isUsingLocalCategoryRegistry()) {
            this.checkCustomFolders();
        }
    }

    private void checkCustomFolders() {
        File metadataFolder = new File(this.getIndexFolderPath(true, "metadata"));
        if (metadataFolder.exists()) {
            this.ensureMetadataIndexAccess();
            File dataDictFolder = new File(this.getIndexFolderPath(true, "dictionary"));
            if (dataDictFolder.exists()) {
                this.ensureDocumentDictIndexAccess();
            }
            this.ensureRegexClassifierAccess();
        }
    }

    public String getTenantID() {
        return this.tenantID;
    }

    private String getIndexFolderPath(boolean isProduction, String indexName) {
        return CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + (isProduction ? "prod" : "republish") + File.separator + indexName;
    }

    public Map<String, DQCategory> getMetadata() {
        if (this.metadata == null) {
            this.metadata = CategoryRegistryManager.getInstance().getSharedCategoryMetadata();
        }
        return this.metadata;
    }

    public Directory getDataDictDirectory() {
        return this.dataDictDirectory;
    }

    public UserDefinedClassifier getRegexClassifier() {
        if (this.regexClassifier == null) {
            return CategoryRegistryManager.getInstance().getRegexClassifier();
        }
        return this.regexClassifier;
    }

    private synchronized void ensureMetadataIndexAccess() {
        if (this.customMetadataIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, CUSTOM, "metadata", this.tenantID));
            String metadataIndexPath = this.getIndexFolderPath(true, "metadata");
            File folder = new File(metadataIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((File)folder));
                this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureDocumentDictIndexAccess() {
        this.ensureMetadataIndexAccess();
        if (this.customDocumentIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, CUSTOM, "dictionary", this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(true, "dictionary");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.dataDictDirectory = FSDirectory.open((File)folder);
                this.customDocumentIndexAccess = new CustomDocumentIndexAccess(this.dataDictDirectory);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureRepublishDataDictIndexAccess() {
        if (this.customRepublishDataDictIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, "republish", "dictionary", this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(false, "dictionary");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customRepublishDataDictIndexAccess = new CustomDocumentIndexAccess((Directory)FSDirectory.open((File)folder));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureRepublishMetadataIndexAccess() {
        if (this.customRepublishMetadataIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, "republish", "metadata", this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(false, "metadata");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customRepublishMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((File)folder));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createCategory(DQCategory category) {
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        } else if (CategoryType.DICT.equals((Object)category.getType())) {
            this.ensureDocumentDictIndexAccess();
        }
        category.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.createCategory(category);
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    public void updateCategory(DQCategory category) {
        if (CategoryType.DICT.equals((Object)category.getType())) {
            this.copyDataDictByCategoryFromSharedDirectory(category.getId());
        } else if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        }
        DQCategory categoryClone = (DQCategory)SerializationUtils.clone((Serializable)category);
        categoryClone.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.insertOrUpdateCategory(categoryClone);
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    private void copyDataDictByCategoryFromSharedDirectory(String categoryId) {
        DQCategory dqCat = this.getMetadata().get(categoryId);
        if (dqCat != null && !Boolean.TRUE.equals(dqCat.getModified()) && !Boolean.TRUE.equals(dqCat.getDeleted())) {
            this.ensureDocumentDictIndexAccess();
            this.customDocumentIndexAccess.copyBaseDocumentsFromSharedDirectory(dqCat);
        }
    }

    public void deleteCategory(DQCategory category) {
        DQCategory categoryClone = (DQCategory)SerializationUtils.clone((Serializable)category);
        categoryClone.setDeleted(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        String categoryId = category.getId();
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.ensureRegexClassifierAccess();
            this.customRegexClassifierAccess.deleteRegex(categoryId);
        }
        if (this.isSystemCategory(category)) {
            this.customMetadataIndexAccess.insertOrUpdateCategory(categoryClone);
            if (!CategoryType.REGEX.equals((Object)category.getType()) && Boolean.TRUE.equals(category.getModified())) {
                this.ensureDocumentDictIndexAccess();
                this.customDocumentIndexAccess.deleteDocumentsByCategoryId(categoryId);
                this.customDocumentIndexAccess.commitChanges();
            }
        } else {
            this.customMetadataIndexAccess.deleteCategory(categoryClone);
            this.ensureDocumentDictIndexAccess();
            this.customDocumentIndexAccess.deleteDocumentsByCategoryId(categoryId);
            this.customDocumentIndexAccess.commitChanges();
        }
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    private boolean isSystemCategory(DQCategory category) {
        return TALEND.equals(category.getCreator()) || SYSTEM.equals(category.getCreator());
    }

    public void reloadCategoryMetadata() {
        this.checkCustomFolders();
        if (this.customMetadataIndexAccess != null) {
            this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
        }
        if (this.customRegexClassifierAccess != null) {
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    public void updateDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::insertOrUpdateDocument);
    }

    public void addDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::createDocument);
    }

    public void deleteDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::deleteDocument);
    }

    private void operationDataDictDocuments(List<DQDocument> documents, Consumer<List<DQDocument>> function) {
        String categoryId = documents.get(0).getCategory().getId();
        DQCategory category = this.getMetadata().get(categoryId);
        if (category != null && !Boolean.TRUE.equals(category.getModified()) && !Boolean.TRUE.equals(category.getDeleted())) {
            this.updateCategory(category);
        }
        function.accept(documents);
        this.customDocumentIndexAccess.commitChanges();
    }

    void closeRepublishDictionaryAccess() {
        try {
            if (this.customRepublishMetadataIndexAccess != null) {
                this.customRepublishMetadataIndexAccess.close();
            }
            if (this.customRepublishDataDictIndexAccess != null) {
                this.customRepublishDataDictIndexAccess.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.customRepublishMetadataIndexAccess = null;
            this.customRepublishDataDictIndexAccess = null;
            this.customRepublishRegexClassifierAccess = null;
        }
    }

    private synchronized void ensureRegexClassifierAccess() {
        if (this.customRegexClassifierAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, CUSTOM, "regex", this.tenantID));
            this.customRegexClassifierAccess = new CustomRegexClassifierAccess(this);
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    private synchronized void ensureRepublishRegexClassifierAccess() {
        if (this.customRepublishRegexClassifierAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, "republish", "regex", this.tenantID));
            this.customRepublishRegexClassifierAccess = new CustomRegexClassifierAccess(this.getIndexFolderPath(false, "regex" + File.separator + "categorizer.json"));
        }
    }

    private void insertOrUpdateRegexCategory(DQCategory category) {
        this.ensureRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRegexClassifierAccess.insertOrUpdateRegex(regEx);
        this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
    }

    public LocalDictionaryCache getDictionaryCache() {
        if (this.localDictionaryCache == null) {
            this.localDictionaryCache = new LocalDictionaryCache(this);
        }
        return this.localDictionaryCache;
    }

    public void closeDictionaryCache() {
        if (this.localDictionaryCache != null) {
            this.localDictionaryCache.close();
            this.localDictionaryCache = null;
        }
    }

    public Collection<DQCategory> listCategories() {
        return this.listCategories(true);
    }

    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (Boolean.TRUE.equals(dqCat.getDeleted()) || !includeOpenCategories && !dqCat.getCompleteness().booleanValue()) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public List<DQCategory> listCategories(CategoryType type) {
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (Boolean.TRUE.equals(dqCat.getDeleted()) || !type.equals((Object)dqCat.getType())) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public DQCategory getCategoryMetadataById(String catId) {
        return this.getMetadata().get(catId);
    }

    public DQCategory getCategoryMetadataByName(String catName) {
        for (DQCategory cat : this.getMetadata().values()) {
            if (!cat.getName().equals(catName)) continue;
            return cat;
        }
        return null;
    }

    public IndexWriter getMetadataIndexWriter() throws IOException {
        this.ensureMetadataIndexAccess();
        return this.customMetadataIndexAccess.getWriter();
    }

    public IndexWriter getDataDictIndexWriter() throws IOException {
        this.ensureDocumentDictIndexAccess();
        return this.customDocumentIndexAccess.getWriter();
    }

    public void beforeRepublish() {
        this.ensureRepublishMetadataIndexAccess();
        for (DQCategory category : this.customRepublishMetadataIndexAccess.readCategoryMedatada().values()) {
            category.setDeleted(Boolean.valueOf(true));
            this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
        }
    }

    public void republishDataDictDocuments(List<DQDocument> documents) {
        this.ensureRepublishDataDictIndexAccess();
        this.customRepublishDataDictIndexAccess.createDocument(documents);
    }

    @Deprecated
    public void republishCategory(DQCategory category) {
        this.republishCategories(Arrays.asList(category));
    }

    public void republishCategories(List<DQCategory> categories) {
        this.ensureRepublishMetadataIndexAccess();
        for (DQCategory category : categories) {
            category.setModified(Boolean.valueOf(this.isModifiedByUser(category)));
            if (CategoryRegistryManager.getInstance().getSharedCategoryMetadata().containsKey(category.getId())) {
                this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
            } else {
                this.customRepublishMetadataIndexAccess.createCategory(category);
            }
            if (!CategoryType.REGEX.equals((Object)category.getType())) continue;
            this.republishRegexCategory(category);
        }
        this.customRepublishMetadataIndexAccess.commitChanges();
    }

    private boolean isModifiedByUser(DQCategory category) {
        boolean isSystem = category.getLastModifier() == null || TALEND.equals(category.getLastModifier()) || SYSTEM.equals(category.getLastModifier());
        return !isSystem;
    }

    private void republishRegexCategory(DQCategory category) {
        this.ensureRepublishRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRepublishRegexClassifierAccess.insertOrUpdateRegex(regEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publishDirectory() throws IOException {
        this.closeRepublishDictionaryAccess();
        File stagingIndexes = new File(CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + "republish");
        File productionIndexes = new File(CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + "prod");
        File backup = new File(productionIndexes.getPath() + ".old");
        if (!backup.exists() && stagingIndexes.exists()) {
            if (productionIndexes.exists()) {
                try {
                    LOGGER.info("[Post Republish] backup prod");
                    FileUtils.copyDirectory((File)productionIndexes, (File)backup);
                    this.copyStagingToProd(stagingIndexes, backup, productionIndexes);
                }
                catch (IOException exception) {
                    LOGGER.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    LOGGER.info("[Post Republish] delete backup");
                    FileUtils.deleteDirectory((File)backup);
                }
            } else {
                FileUtils.copyDirectory((File)stagingIndexes, (File)productionIndexes);
            }
            LOGGER.info("[Post Republish] delete staging contents");
            FileUtils.deleteDirectory((File)stagingIndexes);
            this.reloadCategoryMetadata();
        }
    }

    private void copyStagingToProd(File stagingIndexes, File backup, File productionIndexes) throws IOException {
        try {
            File regexFile;
            File dictionaryFolder;
            LOGGER.info("[Post Republish] insert staging directory into prod");
            File metadataFolder = new File(stagingIndexes.getAbsolutePath() + File.separator + "metadata");
            if (metadataFolder.exists()) {
                this.ensureMetadataIndexAccess();
                this.customMetadataIndexAccess.copyStagingContent(metadataFolder.getAbsolutePath());
            }
            if ((dictionaryFolder = new File(stagingIndexes.getAbsolutePath() + File.separator + "dictionary")).exists()) {
                this.ensureDocumentDictIndexAccess();
                this.customDocumentIndexAccess.copyStagingContent(dictionaryFolder.getAbsolutePath());
            }
            if ((regexFile = new File(stagingIndexes.getAbsolutePath() + File.separator + "regex" + File.separator + "categorizer.json")).exists()) {
                this.ensureRegexClassifierAccess();
                this.customRegexClassifierAccess.copyStagingContent(regexFile.getAbsolutePath());
            }
        }
        catch (IOException exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            FileUtils.cleanDirectory((File)productionIndexes);
            FileUtils.copyDirectory((File)backup, (File)productionIndexes);
        }
    }

    public DictionarySnapshot getDictionarySnapshot() {
        return new DictionarySnapshot(this.getMetadata(), new LuceneIndex(CategoryRegistryManager.getInstance().getSharedDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), this.getDataDictDirectory() == null ? null : new LuceneIndex(this.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), new LuceneIndex(CategoryRegistryManager.getInstance().getSharedKeywordDirectory(), DictionarySearchMode.MATCH_SEMANTIC_KEYWORD), this.getRegexClassifier());
    }

    public void delete() {
        LOGGER.info("Delete data for tenant " + this.tenantID);
        File rootFolder = new File(CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID);
        try {
            FileUtils.deleteDirectory((File)rootFolder);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

