/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.internal.AbstractCustomIndexAccess;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;

public class CustomDocumentIndexAccess
extends AbstractCustomIndexAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDocumentIndexAccess.class);

    public CustomDocumentIndexAccess(Directory directory) throws IOException {
        super(directory);
        this.init();
    }

    private void init() {
        try {
            boolean isLuceneDir = DirectoryReader.indexExists((Directory)this.directory);
            if (!isLuceneDir) {
                LOGGER.debug("Document index is not a lucene index, trying to initialize an empty lucene index ");
                this.commitChanges();
            }
            this.mgr = new SearcherManager(this.directory, null);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void createDocument(List<DQDocument> documents) {
        ArrayList<Document> luceneDocuments = new ArrayList<Document>();
        for (DQDocument document : documents) {
            luceneDocuments.add(DictionaryUtils.dqDocumentToLuceneDocument(document));
        }
        LOGGER.debug("create " + documents.size() + " documents");
        try {
            this.getWriter().addDocuments(luceneDocuments);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void insertOrUpdateDocument(List<DQDocument> documents) {
        ArrayList<DQDocument> documentsToCreate = new ArrayList<DQDocument>();
        try {
            LOGGER.debug("update " + documents.size() + " documents");
            for (DQDocument document : documents) {
                Term term = new Term("docid", document.getId());
                this.mgr.maybeRefreshBlocking();
                IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
                if (searcher.search((Query)new TermQuery((Term)term), (int)1).totalHits == 1) {
                    this.getWriter().updateDocument(term, (Iterable)DictionaryUtils.dqDocumentToLuceneDocument(document).getFields());
                } else {
                    documentsToCreate.add(document);
                }
                this.mgr.release((Object)searcher);
            }
            this.createDocument(documentsToCreate);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDocument(List<DQDocument> documents) {
        for (DQDocument document : documents) {
            LOGGER.debug("deleteDocument " + document);
            Term luceneId = new Term("docid", document.getId());
            try {
                this.getWriter().deleteDocuments(new Term[]{luceneId});
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteDocumentsByCategoryId(String categoryId) {
        LOGGER.debug("deleteDocuments by categoryId " + categoryId);
        Term luceneId = new Term("catid", categoryId);
        try {
            this.getWriter().deleteDocuments(new Term[]{luceneId});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void copyBaseDocumentsFromSharedDirectory(DQCategory dqCategory) {
        try (Directory srcDir = ClassPathDirectory.open(CategoryRegistryManager.getInstance().getDictionaryURI());
             DirectoryReader reader = DirectoryReader.open((Directory)srcDir);){
            IndexSearcher sharedLuceneDocumentSearcher = new IndexSearcher((IndexReader)reader);
            Term searchTerm = new Term("catid", dqCategory.getId());
            for (ScoreDoc d : sharedLuceneDocumentSearcher.search((Query)new TermQuery((Term)searchTerm), (int)Integer.MAX_VALUE).scoreDocs) {
                DQDocument document = DictionaryUtils.dictionaryEntryFromDocument(sharedLuceneDocumentSearcher.doc(d.doc));
                this.getWriter().addDocument((Iterable)DictionaryUtils.dqDocumentToLuceneDocument(document));
            }
            this.commitChanges();
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

