/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryMetadataUtils;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.internal.AbstractCustomIndexAccess;
import org.talend.dataquality.semantic.model.DQCategory;

public class CustomMetadataIndexAccess
extends AbstractCustomIndexAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomMetadataIndexAccess.class);

    public CustomMetadataIndexAccess(Directory directory) {
        super(directory);
        this.init();
    }

    private void init() {
        try {
            boolean isLuceneDir = DirectoryReader.indexExists((Directory)this.directory);
            if (!isLuceneDir || this.getReader().maxDoc() == 0) {
                LOGGER.info("Metadata index is not a lucene index or is empty, trying to make a copy from shared metadata.");
                for (DQCategory dqCat : CategoryRegistryManager.getInstance().getSharedCategoryMetadata().values()) {
                    this.createCategory(dqCat);
                }
                this.commitChanges();
            }
            this.mgr = new SearcherManager(this.directory, null);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, DQCategory> readCategoryMedatada() {
        return CategoryMetadataUtils.loadMetadataFromIndex(this.directory);
    }

    public void createCategory(DQCategory category) {
        LOGGER.debug("createCategory: " + category);
        try {
            Document luceneDoc = DictionaryUtils.categoryToDocument(category);
            this.getWriter().addDocument((Iterable)luceneDoc);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void insertOrUpdateCategory(DQCategory category) {
        LOGGER.debug("insertOrUpdateCategory: " + category);
        Term searchTerm = new Term("catid", category.getId());
        TermQuery termQuery = new TermQuery(searchTerm);
        try {
            this.mgr.maybeRefreshBlocking();
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            TopDocs result = searcher.search((Query)termQuery, 1);
            this.mgr.release((Object)searcher);
            if (result.totalHits == 1) {
                Term term = new Term("catid", category.getId());
                List fields = DictionaryUtils.categoryToDocument(category).getFields();
                this.getWriter().updateDocument(term, (Iterable)fields);
            } else {
                this.createCategory(category);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCategory(DQCategory category) {
        LOGGER.debug("deleteCategory: " + category);
        Term luceneId = new Term("catid", category.getId());
        try {
            this.getWriter().deleteDocuments(new Term[]{luceneId});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

