/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UDCategorySerDeser;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRE2JRegexValidator;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRegexValidator;

public class BroadcastRegexObject
implements Serializable {
    private static final long serialVersionUID = -7692833458780761739L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastRegexObject.class);
    private UserDefinedClassifier regexClassifier;

    public BroadcastRegexObject() {
    }

    public BroadcastRegexObject(UserDefinedClassifier regexClassifier) {
        this.regexClassifier = regexClassifier;
    }

    public BroadcastRegexObject(UserDefinedClassifier udc, Set<String> categories) {
        this.regexClassifier = new UserDefinedClassifier();
        for (ISubCategory c : udc.getClassifiers()) {
            if (!categories.contains(c.getId())) continue;
            UserDefinedRegexValidator validator = (UserDefinedRegexValidator)c.getValidator();
            if (validator instanceof UserDefinedRE2JRegexValidator) {
                UserDefinedCategory newCat = (UserDefinedCategory)SerializationUtils.clone((Serializable)c);
                UserDefinedRegexValidator newValidator = new UserDefinedRegexValidator();
                newValidator.setCaseInsensitive(validator.getCaseInsensitive());
                newValidator.setPatternString(validator.getPatternString());
                newValidator.setSubValidatorClassName(validator.getSubValidatorClassName());
                newCat.setValidator(newValidator);
                this.regexClassifier.addSubCategory(newCat);
                continue;
            }
            this.regexClassifier.addSubCategory(c);
        }
    }

    public BroadcastRegexObject(URI regexPath) {
        try {
            this.regexClassifier = UDCategorySerDeser.readJsonFile(regexPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load resource from " + regexPath, (Throwable)e);
        }
    }

    public UserDefinedClassifier getRegexClassifier() {
        return this.regexClassifier;
    }

    public void setRegexClassifier(UserDefinedClassifier regexClassifier) {
        this.regexClassifier = regexClassifier;
    }
}

