/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.broadcast.BroadcastIndexObject;
import org.talend.dataquality.semantic.broadcast.BroadcastMetadataObject;
import org.talend.dataquality.semantic.broadcast.BroadcastRegexObject;
import org.talend.dataquality.semantic.broadcast.TdqCategories;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.model.DQCategory;

public class TdqCategoriesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TdqCategoriesFactory.class);

    private TdqCategoriesFactory() {
    }

    public static final TdqCategories createEmptyTdqCategories() {
        return new TdqCategories(new BroadcastMetadataObject(Collections.emptyMap()), new BroadcastIndexObject(Collections.emptyList()), new BroadcastIndexObject(Collections.emptyList()), new BroadcastIndexObject(Collections.emptyList()), new BroadcastRegexObject(new UserDefinedClassifier()));
    }

    public static final TdqCategories createFullTdqCategories() {
        return TdqCategoriesFactory.createTdqCategories(null);
    }

    public static final TdqCategories createTdqCategories(Set<String> categoryNames) {
        CategoryRegistryManager crm = CategoryRegistryManager.getInstance();
        HashMap<String, DQCategory> selectedCategoryMap = new HashMap<String, DQCategory>();
        HashSet<String> unmodifiedSelectedCategoryIds = new HashSet<String>();
        for (DQCategory dqCat : crm.listCategories(false)) {
            if (categoryNames != null && !categoryNames.contains(dqCat.getName())) continue;
            selectedCategoryMap.put(dqCat.getId(), dqCat);
            if (dqCat.getModified().booleanValue()) continue;
            unmodifiedSelectedCategoryIds.add(dqCat.getId());
        }
        Set<String> selectedCategoryIds = selectedCategoryMap.keySet();
        BroadcastIndexObject sharedDictionary = new BroadcastIndexObject(crm.getSharedDataDictDirectory(), unmodifiedSelectedCategoryIds);
        LOGGER.debug("Returning shared data dictionary.");
        Directory customDataDictDir = crm.getCustomDictionaryHolder().getDataDictDirectory();
        BroadcastIndexObject customDictionary = new BroadcastIndexObject(customDataDictDir, selectedCategoryIds);
        LOGGER.debug("Returning custom data dictionary.");
        BroadcastIndexObject keyword = new BroadcastIndexObject(crm.getSharedKeywordDirectory(), selectedCategoryIds);
        LOGGER.debug("Returning shared keyword index.");
        UserDefinedClassifier classifiers = crm.getCustomDictionaryHolder().getRegexClassifier();
        BroadcastRegexObject regex = new BroadcastRegexObject(classifiers, selectedCategoryIds);
        LOGGER.debug("Returning regexes.");
        BroadcastMetadataObject meta = new BroadcastMetadataObject(selectedCategoryMap);
        LOGGER.debug("Returning category metadata.");
        return new TdqCategories(meta, sharedDictionary, customDictionary, keyword, regex);
    }

    public static final TdqCategories createSharedTdqCategories() {
        CategoryRegistryManager crm = CategoryRegistryManager.getInstance();
        Map<String, DQCategory> selectedCategoryMap = crm.getSharedCategoryMetadata().entrySet().stream().filter(entry -> Boolean.TRUE.equals(((DQCategory)entry.getValue()).getCompleteness())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new TdqCategories(new BroadcastMetadataObject(selectedCategoryMap), new BroadcastIndexObject(crm.getSharedDataDictDirectory(), selectedCategoryMap.keySet()), new BroadcastIndexObject(Collections.emptyList()), new BroadcastIndexObject(crm.getSharedKeywordDirectory(), selectedCategoryMap.keySet()), new BroadcastRegexObject(crm.getRegexClassifier(), selectedCategoryMap.keySet()));
    }
}

