/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRegexValidator;
import org.talend.dataquality.semantic.classifier.impl.AbstractSubCategoryClassifier;
import org.talend.dataquality.semantic.filter.ISemanticFilter;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.MainCategory;
import org.talend.dataquality.semantic.validator.AbstractRegexSemanticValidator;
import org.talend.dataquality.semantic.validator.ISemanticValidator;

public class UserDefinedClassifier
extends AbstractSubCategoryClassifier {
    private static final long serialVersionUID = 6641017802505586690L;

    public boolean addSubCategory(ISubCategory category) {
        return this.potentialSubCategories.add(category);
    }

    public boolean insertOrUpdateSubCategory(ISubCategory category) {
        if (this.potentialSubCategories.contains(category)) {
            return this.updateSubCategory(category);
        }
        return this.addSubCategory(category);
    }

    public boolean updateSubCategory(ISubCategory category) {
        if (this.removeSubCategory(category)) {
            return this.addSubCategory(category);
        }
        return false;
    }

    public boolean removeSubCategory(ISubCategory category) {
        return this.potentialSubCategories.remove(category);
    }

    @Override
    public Set<String> classify(String data) {
        MainCategory mainCategory = MainCategory.getMainCategory((String)data);
        return this.classify(data, mainCategory);
    }

    @Override
    public boolean validCategories(String str, DQCategory semanticType, Set<DQCategory> children) {
        MainCategory mainCategory = MainCategory.getMainCategory((String)str);
        if (mainCategory == MainCategory.NULL || mainCategory == MainCategory.BLANK) {
            return false;
        }
        if (CollectionUtils.isEmpty(children)) {
            return this.validCategories(str, mainCategory, semanticType);
        }
        return this.validChildrenCategories(str, mainCategory, children);
    }

    private boolean validChildrenCategories(String str, MainCategory mainCategory, Set<DQCategory> children) {
        int cpt = 0;
        HashSet<String> childrenId = new HashSet<String>();
        for (DQCategory child : children) {
            childrenId.add(child.getId());
        }
        for (ISubCategory classifier : this.potentialSubCategories) {
            if (!childrenId.contains(classifier.getId())) continue;
            ++cpt;
            if (this.isValid(str, mainCategory, (UserDefinedCategory)classifier, true)) {
                return true;
            }
            if (cpt != children.size()) continue;
            return false;
        }
        return false;
    }

    private boolean validCategories(String str, MainCategory mainCategory, DQCategory semanticType) {
        for (ISubCategory classifier : this.potentialSubCategories) {
            if (!semanticType.getId().equals(classifier.getId())) continue;
            return this.isValid(str, mainCategory, (UserDefinedCategory)classifier, true);
        }
        return false;
    }

    public Set<String> classify(String str, MainCategory mainCategory) {
        HashSet<String> catSet = new HashSet<String>();
        if (mainCategory != MainCategory.NULL && mainCategory != MainCategory.BLANK) {
            for (ISubCategory classifier : this.potentialSubCategories) {
                if (!this.isValid(str, mainCategory, (UserDefinedCategory)classifier, false)) continue;
                catSet.add(classifier.getId());
            }
        }
        return catSet;
    }

    private boolean isValid(String str, MainCategory mainCategory, UserDefinedCategory classifier, boolean caseSensitive) {
        MainCategory classifierCategory = classifier.getMainCategory();
        if (classifierCategory == null) {
            return false;
        }
        if (mainCategory == MainCategory.Alpha || mainCategory == MainCategory.Numeric ? !classifierCategory.equals((Object)mainCategory) && !classifierCategory.equals((Object)MainCategory.AlphaNumeric) : !classifierCategory.equals((Object)mainCategory)) {
            return false;
        }
        if (this.invalidFilter(str, classifier.getFilter())) {
            return false;
        }
        return this.validValidator(str, classifier.getValidator(), caseSensitive);
    }

    private boolean invalidFilter(String str, ISemanticFilter filter) {
        return filter != null && !filter.isQualified(str);
    }

    private boolean validValidator(String str, ISemanticValidator validator, boolean caseSensitive) {
        return validator != null && validator.isValid(str, caseSensitive);
    }

    public String getPatternStringByCategoryId(String categoryId) {
        if (categoryId == null) {
            return null;
        }
        for (ISubCategory category : this.getClassifiers()) {
            if (!categoryId.equals(category.getId())) continue;
            return ((UserDefinedCategory)category).getValidator().getPatternString();
        }
        return null;
    }

    public boolean isGenerexCompliant(String categoryId) {
        if (categoryId == null) {
            return false;
        }
        for (ISubCategory category : this.getClassifiers()) {
            if (!categoryId.equals(category.getId()) || !(category.getValidator() instanceof UserDefinedRegexValidator)) continue;
            AbstractRegexSemanticValidator validator = (AbstractRegexSemanticValidator)category.getValidator();
            return validator.getGenerexCompliant();
        }
        return false;
    }
}

