/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.talend.dataquality.datamasking.functions.FunctionString;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class GenerateFromDictionaries
extends FunctionString {
    private static final long serialVersionUID = 1476820256067746995L;
    protected List<String> valuesInDictionaries = null;
    private DictionarySnapshot dictionarySnapshot;
    private String semanticCategoryId;

    protected String doGenerateMaskedFieldWithRandom(String str, Random r) {
        if (!this.valuesInDictionaries.isEmpty()) {
            return this.valuesInDictionaries.get(r.nextInt(this.valuesInDictionaries.size()));
        }
        return "";
    }

    private List<String> getValuesFromIndex(Index index) {
        List<Document> listLuceneDocs = ((LuceneIndex)index).getSearcher().listDocumentsByCategoryId(this.semanticCategoryId, 0, Integer.MAX_VALUE);
        return listLuceneDocs.stream().flatMap(doc -> Arrays.asList(doc.getValues("raw")).stream()).collect(Collectors.toList());
    }

    public void parse(String semanticCategoryId, boolean keepNullValues) {
        this.semanticCategoryId = semanticCategoryId;
        this.setKeepNull(keepNullValues);
        if (this.valuesInDictionaries == null && this.dictionarySnapshot != null) {
            DQCategory cat = this.dictionarySnapshot.getMetadata().get(semanticCategoryId);
            this.valuesInDictionaries = new ArrayList<String>();
            if (cat != null) {
                if (!cat.getModified().booleanValue()) {
                    this.valuesInDictionaries.addAll(this.getValuesFromIndex(this.dictionarySnapshot.getSharedDataDict()));
                } else {
                    this.valuesInDictionaries.addAll(this.getValuesFromIndex(this.dictionarySnapshot.getCustomDataDict()));
                }
            }
        }
    }

    public void setDictionarySnapshot(DictionarySnapshot dictionarySnapshot) {
        this.dictionarySnapshot = dictionarySnapshot;
    }
}

