/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.datamasking.FunctionType;

public enum MaskableCategoryEnum {
    ADDRESS_LINE("Address Line", FunctionType.MASK_ADDRESS),
    EMAIL("Email", FunctionType.MASK_EMAIL),
    FULL_NAME("Full Name", FunctionType.REPLACE_CHARACTERS_WITH_GENERATION),
    US_PHONE("US Phone", FunctionType.GENERATE_PHONE_NUMBER_US),
    FR_PHONE("FR Phone", FunctionType.GENERATE_PHONE_NUMBER_FRENCH),
    UK_PHONE("UK Phone", FunctionType.GENERATE_PHONE_NUMBER_UK),
    DE_PHONE("DE Phone", FunctionType.GENERATE_PHONE_NUMBER_GERMANY),
    DE_POSTAL_CODE("DE Postal Code", FunctionType.REPLACE_CHARACTERS_WITH_GENERATION),
    US_SSN("US Social Security Number", FunctionType.GENERATE_SSN_US),
    FR_SSN("FR Social Security Number", FunctionType.GENERATE_SSN_FRENCH),
    UK_SSN("UK Social Security Number", FunctionType.GENERATE_SSN_UK),
    IBAN("IBAN", FunctionType.GENERATE_ACCOUNT_NUMBER_FORMAT),
    MASTERCARD("Mastercard Credit Card", FunctionType.GENERATE_CREDIT_CARD_FORMAT_STRING),
    US_CREDIT_CARD("AmEx Credit Card", FunctionType.GENERATE_CREDIT_CARD_FORMAT_STRING),
    VISACARD("Visa Credit Card", FunctionType.GENERATE_CREDIT_CARD_FORMAT_STRING),
    SEDOL("Stock Exchange Daily Official List", FunctionType.REPLACE_CHARACTERS_WITH_GENERATION);

    private String displayName;
    private FunctionType functionType;
    private String parameter;
    private static final Logger LOGGER;

    private MaskableCategoryEnum(String displayName, FunctionType functionType) {
        this.displayName = displayName;
        this.functionType = functionType;
    }

    public String getId() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public String getParameter() {
        return this.parameter;
    }

    public static MaskableCategoryEnum getCategoryById(String catId) {
        try {
            return MaskableCategoryEnum.valueOf(catId);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(MaskableCategoryEnum.class);
    }
}

