/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.talend.dataquality.datamasking.FunctionMode;
import org.talend.dataquality.datamasking.functions.Function;
import org.talend.dataquality.datamasking.semantic.ReplaceCharacterHelper;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.datamasking.SemanticMaskerFunctionFactory;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.StandardDictionarySnapshotProvider;
import org.talend.dataquality.semantic.statistics.SemanticQualityAnalyzer;

public class ValueDataMasker
implements Serializable {
    private static final long serialVersionUID = 7071792900542293289L;
    private Function<String> function;
    private DQCategory category;
    private SemanticQualityAnalyzer semanticQualityAnalyzer = null;

    Function<String> getFunction() {
        return this.function;
    }

    public ValueDataMasker(Function<String> function) {
        this.function = function;
    }

    public ValueDataMasker(String semanticCategory, String dataType) {
        this(semanticCategory, dataType, null);
    }

    public ValueDataMasker(String semanticCategory, String dataType, List<String> params) {
        this(semanticCategory, dataType, params, null);
    }

    public ValueDataMasker(String semanticCategory, String dataType, List<String> params, DictionarySnapshot dictionarySnapshot) {
        this.function = SemanticMaskerFunctionFactory.createMaskerFunctionForSemanticCategory(semanticCategory, dataType, params, dictionarySnapshot);
        this.initCategory(semanticCategory, dictionarySnapshot);
    }

    public ValueDataMasker(String semanticCategory, String dataType, List<String> params, DictionarySnapshot dictionarySnapshot, String seed, FunctionMode mode) {
        this.function = SemanticMaskerFunctionFactory.createMaskerFunctionForSemanticCategory(semanticCategory, dataType, params, dictionarySnapshot, seed, mode);
        this.initCategory(semanticCategory, dictionarySnapshot);
    }

    private void initCategory(String semanticCategory, DictionarySnapshot dictionarySnapshot) {
        DQCategory dQCategory = this.category = dictionarySnapshot != null ? dictionarySnapshot.getDQCategoryByName(semanticCategory) : CategoryRegistryManager.getInstance().getCategoryMetadataByName(semanticCategory);
        if (this.category != null) {
            DictionarySnapshot dictionary;
            DictionarySnapshot dictionarySnapshot2 = dictionary = dictionarySnapshot != null ? dictionarySnapshot : new StandardDictionarySnapshotProvider().get();
            if (this.category.getCompleteness().booleanValue()) {
                this.semanticQualityAnalyzer = new SemanticQualityAnalyzer(dictionary, this.category.getName());
            }
        }
    }

    public String maskValue(String input) {
        if (this.semanticQualityAnalyzer != null && !this.semanticQualityAnalyzer.isValid(this.category, input)) {
            Random r = this.function.getRandom();
            if (FunctionMode.CONSISTENT == this.function.getMaskingMode()) {
                r = new Random();
                r.setSeed(input.hashCode() ^ this.function.getSeed().hashCode());
            }
            return ReplaceCharacterHelper.replaceCharacters((String)input, (Random)r);
        }
        try {
            return (String)this.function.generateMaskedRow((Object)input);
        }
        catch (RuntimeException e) {
            return ReplaceCharacterHelper.replaceCharacters((String)input, (Random)this.function.getRandom());
        }
    }

    public void resetExtraParameter(String extraParam) {
        this.function.parse(extraParam, true);
    }
}

