/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.semantic.extraction.MatchedPart;
import org.talend.dataquality.semantic.extraction.TokenizedString;

public class MatchedPartDict
extends MatchedPart {
    private static String DASH = "-";
    private static String SPACE = " ";

    public MatchedPartDict(TokenizedString originalField, int startToken, int endToken, String luceneMatch) {
        this.originalField = originalField;
        this.checkBounds(startToken, endToken);
        this.start = startToken;
        this.end = endToken;
        this.initTokenPositions();
        this.computeExactMatch(luceneMatch);
    }

    @Override
    protected void checkBounds(int start, int end) {
        if (start < 0 || end < 0 || end < start || end >= this.originalField.getTokens().size()) {
            throw new IllegalArgumentException("Bounds for match are incorrect : start = " + start + " end = " + end);
        }
    }

    private void computeExactMatch(String luceneMatch) {
        String originalValue = this.originalField.getValue();
        int indexStart = 0;
        List<String> tokens = this.originalField.getTokens();
        for (int i = 0; i < this.start; ++i) {
            indexStart += tokens.get(i).length() + 1;
        }
        String originalWithModif = StringUtils.stripAccents((String)originalValue);
        originalWithModif = originalWithModif.substring(indexStart).toLowerCase().replaceAll(DASH, SPACE);
        String match = StringUtils.stripAccents((String)luceneMatch);
        String commonSubString = MatchedPartDict.longestCommonSubstring(originalWithModif, (match = match.toLowerCase().replaceAll(DASH, SPACE)).toLowerCase());
        if (!commonSubString.isEmpty()) {
            int indexOf = originalWithModif.indexOf(commonSubString);
            this.exactMatch = originalValue.substring(indexStart + indexOf, indexStart + indexOf + commonSubString.length());
        }
    }

    private static String longestCommonSubstring(String s1, String s2) {
        int start = 0;
        int max = 0;
        for (int i = 0; i < s1.length(); ++i) {
            for (int j = 0; j < s2.length(); ++j) {
                int x = 0;
                while (s1.charAt(i + x) == s2.charAt(j + x) && i + ++x < s1.length() && j + x < s2.length()) {
                }
                if (x <= max) continue;
                max = x;
                start = i;
            }
        }
        return s1.substring(start, start + max);
    }
}

